/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.sounds.Sound;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.resources.sounds.TickableSoundInstance;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.client.sounds.WeighedSoundEvents;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;

public class DebuffTimedSound
implements TickableSoundInstance {
    private static final float volumeMultiplier = 1.25f;
    private static final Map<SoundEvent, DebuffTimedSound> ACTIVE_SOUNDS = new HashMap<SoundEvent, DebuffTimedSound>();
    private final float minusPerTick;
    private final int debuffDuration;
    private final ResourceLocation soundLocation;
    private final SoundEvent event;
    private final WeakReference<LocalPlayer> player;
    private final RandomSource random = SoundInstance.m_235150_();
    private Sound sound;
    private float volume = 1.25f;
    private int ticks;

    public static void playHurtSound(SoundEvent event, int duration) {
        if (!((Boolean)FirstAidConfig.CLIENT.enableSounds.get()).booleanValue()) {
            return;
        }
        SoundManager soundHandler = Minecraft.m_91087_().m_91106_();
        DebuffTimedSound matchingSound = ACTIVE_SOUNDS.get(event);
        if (matchingSound != null) {
            if (!matchingSound.m_7801_()) {
                soundHandler.m_120399_((SoundInstance)matchingSound);
            }
            ACTIVE_SOUNDS.remove(event);
        }
        DebuffTimedSound newSound = new DebuffTimedSound(event, duration);
        soundHandler.m_120367_((SoundInstance)newSound);
        ACTIVE_SOUNDS.put(event, newSound);
    }

    public DebuffTimedSound(SoundEvent event, int debuffDuration) {
        this.event = event;
        this.soundLocation = event.m_11660_();
        this.player = new WeakReference<LocalPlayer>(Minecraft.m_91087_().f_91074_);
        this.debuffDuration = Integer.min(300, debuffDuration);
        this.minusPerTick = 1.0f / (float)this.debuffDuration * 1.25f;
    }

    public boolean m_7801_() {
        boolean done;
        LocalPlayer player = (LocalPlayer)this.player.get();
        boolean bl = done = player == null || this.ticks >= this.debuffDuration || player.m_21223_() <= 0.0f;
        if (done) {
            ACTIVE_SOUNDS.remove(this.event);
        }
        return done;
    }

    @Nonnull
    public ResourceLocation m_7904_() {
        return this.soundLocation;
    }

    @Nullable
    public WeighedSoundEvents m_6775_(@Nonnull SoundManager handler) {
        WeighedSoundEvents soundEventAccessor = handler.m_120384_(this.soundLocation);
        if (soundEventAccessor == null) {
            FirstAid.LOGGER.warn("Missing sound for location " + this.soundLocation);
            this.sound = SoundManager.f_120344_;
        } else {
            this.sound = soundEventAccessor.m_213718_(this.random);
        }
        return soundEventAccessor;
    }

    @Nonnull
    public Sound m_5891_() {
        return this.sound;
    }

    @Nonnull
    public SoundSource m_8070_() {
        return SoundSource.PLAYERS;
    }

    public boolean m_7775_() {
        return false;
    }

    public boolean m_7796_() {
        return false;
    }

    public int m_7766_() {
        return 0;
    }

    public float m_7769_() {
        return this.volume;
    }

    public float m_7783_() {
        return 1.0f;
    }

    public double m_7772_() {
        LocalPlayer player = (LocalPlayer)this.player.get();
        if (player == null) {
            return 0.0;
        }
        return player.m_20185_();
    }

    public double m_7780_() {
        LocalPlayer player = (LocalPlayer)this.player.get();
        if (player == null) {
            return 0.0;
        }
        return player.m_20186_();
    }

    public double m_7778_() {
        LocalPlayer player = (LocalPlayer)this.player.get();
        if (player == null) {
            return 0.0;
        }
        return player.m_20189_();
    }

    @Nonnull
    public SoundInstance.Attenuation m_7438_() {
        return SoundInstance.Attenuation.NONE;
    }

    public void m_7788_() {
        ++this.ticks;
        this.volume = Math.max(0.15f, this.volume - this.minusPerTick);
    }
}

