/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.FlashStateManager;
import ichttt.mods.firstaid.client.gui.GuiHealthScreen;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.client.util.PlayerModelRenderer;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.gui.screens.ChatScreen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;

public class HUDHandler
implements ResourceManagerReloadListener,
IGuiOverlay {
    public static final HUDHandler INSTANCE = new HUDHandler();
    private static final int FADE_TIME = 30;
    private final Map<EnumPlayerPart, String> TRANSLATION_MAP = new EnumMap<EnumPlayerPart, String>(EnumPlayerPart.class);
    private final FlashStateManager flashStateManager = new FlashStateManager();
    private int maxLength;
    public int ticker = -1;

    public void m_6213_(@Nonnull ResourceManager resourceManager) {
        this.buildTranslationTable();
    }

    private synchronized void buildTranslationTable() {
        FirstAid.LOGGER.debug("Building GUI translation table");
        this.TRANSLATION_MAP.clear();
        this.maxLength = 0;
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            String translated = I18n.m_118938_((String)("firstaid.gui." + part.toString().toLowerCase(Locale.ENGLISH)), (Object[])new Object[0]);
            this.maxLength = Math.max(this.maxLength, Minecraft.m_91087_().f_91062_.m_92895_(translated));
            this.TRANSLATION_MAP.put(part, translated);
        }
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public void render(ForgeGui gui, PoseStack mStack, float partialTicks, int screenWidth, int screenHeight) {
        if (FirstAidConfig.CLIENT.overlayMode.get() == FirstAidConfig.Client.OverlayMode.OFF) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        if (mc.f_91074_ == null || !mc.f_91074_.m_6084_()) {
            return;
        }
        mc.m_91307_().m_6180_("FirstAidOverlay");
        this.doRenderOverlay(mStack, mc, gui, partialTicks);
        mc.m_91307_().m_7238_();
        mc.m_91307_().m_7238_();
    }

    private void doRenderOverlay(PoseStack stack, Minecraft mc, ForgeGui gui, float partialTicks) {
        int visibleTicks;
        mc.m_91307_().m_6180_("prepare");
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)mc.f_91074_);
        if (!FirstAid.isSynced) {
            return;
        }
        if (this.TRANSLATION_MAP.isEmpty()) {
            this.buildTranslationTable();
        }
        if ((visibleTicks = ((Integer)FirstAidConfig.CLIENT.visibleDurationTicks.get()).intValue()) != -1) {
            visibleTicks += 30;
        }
        boolean playerDead = damageModel.isDead((Player)mc.f_91074_);
        for (AbstractDamageablePart damageablePart : damageModel) {
            if (!HealthRenderUtils.healthChanged(damageablePart, playerDead)) continue;
            if (visibleTicks != -1) {
                this.ticker = Math.max(this.ticker, visibleTicks);
            }
            if (!((Boolean)FirstAidConfig.CLIENT.flash.get()).booleanValue()) continue;
            this.flashStateManager.setActive(Util.m_137550_());
        }
        FirstAidConfig.Client.OverlayMode overlayMode = (FirstAidConfig.Client.OverlayMode)((Object)FirstAidConfig.CLIENT.overlayMode.get());
        if (overlayMode == FirstAidConfig.Client.OverlayMode.OFF || GuiHealthScreen.isOpen && !overlayMode.isPlayerModel() || !gui.shouldDrawSurvivalElements()) {
            return;
        }
        if (visibleTicks != -1 && this.ticker < 0) {
            return;
        }
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        int xOffset = (Integer)FirstAidConfig.CLIENT.xOffset.get();
        int yOffset = (Integer)FirstAidConfig.CLIENT.yOffset.get();
        boolean playerModel = overlayMode.isPlayerModel();
        switch ((FirstAidConfig.Client.Position)((Object)FirstAidConfig.CLIENT.pos.get())) {
            case TOP_LEFT: {
                if (!playerModel) break;
                ++xOffset;
                break;
            }
            case TOP_RIGHT: {
                xOffset = mc.m_91268_().m_85445_() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() + this.maxLength);
                break;
            }
            case BOTTOM_LEFT: {
                if (playerModel) {
                    ++xOffset;
                }
                yOffset = mc.m_91268_().m_85446_() - yOffset - (playerModel ? 66 : 80);
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset = mc.m_91268_().m_85445_() - xOffset - (playerModel ? 34 : damageModel.getMaxRenderSize() + this.maxLength);
                yOffset = mc.m_91268_().m_85446_() - yOffset - (playerModel ? 62 : 80);
                break;
            }
            default: {
                throw new RuntimeException("Invalid config option for position: " + FirstAidConfig.CLIENT.pos.get());
            }
        }
        if (mc.f_91080_ instanceof ChatScreen && FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.BOTTOM_LEFT) {
            return;
        }
        if (mc.f_91066_.f_92063_ && FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.TOP_LEFT) {
            return;
        }
        boolean enableAlphaBlend = visibleTicks != -1 && this.ticker < 30;
        int alpha = enableAlphaBlend ? Mth.m_14045_((int)((int)((float)(30 - this.ticker) * 255.0f / 30.0f)), (int)((Integer)FirstAidConfig.CLIENT.alpha.get()), (int)250) : (Integer)FirstAidConfig.CLIENT.alpha.get();
        stack.m_85836_();
        stack.m_85837_((double)xOffset, (double)yOffset, 0.0);
        if (enableAlphaBlend) {
            RenderSystem.m_69478_();
            RenderSystem.m_69416_((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        }
        mc.m_91307_().m_6182_("render");
        if (overlayMode.isPlayerModel()) {
            boolean fourColors = overlayMode == FirstAidConfig.Client.OverlayMode.PLAYER_MODEL_4_COLORS;
            PlayerModelRenderer.renderPlayerHealth(stack, damageModel, fourColors, (GuiComponent)gui, this.flashStateManager.update(Util.m_137550_()), alpha, partialTicks);
        } else {
            int xTranslation = this.maxLength;
            for (AbstractDamageablePart part : damageModel) {
                mc.f_91062_.m_92750_(stack, this.TRANSLATION_MAP.get((Object)part.part), 0.0f, 0.0f, 0xFFFFFF - (alpha << 24 & 0xFF000001));
                if (FirstAidConfig.CLIENT.overlayMode.get() == FirstAidConfig.Client.OverlayMode.NUMBERS) {
                    HealthRenderUtils.drawHealthString(stack, part, xTranslation, 0.0f, false);
                } else {
                    HealthRenderUtils.drawHealth(stack, part, xTranslation, 0.0f, (GuiComponent)gui, false);
                }
                stack.m_85837_(0.0, 10.0, 0.0);
            }
        }
        if (enableAlphaBlend) {
            RenderSystem.m_69461_();
        }
        stack.m_85849_();
    }
}

