/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.gui.FlashStateManager;
import ichttt.mods.firstaid.common.EventHandler;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.text.DecimalFormat;
import java.util.EnumMap;
import java.util.Objects;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffects;

public class HealthRenderUtils {
    public static final ResourceLocation GUI_LOCATION = new ResourceLocation("firstaid", "textures/gui/show_wounds.png");
    public static final DecimalFormat TEXT_FORMAT = new DecimalFormat("0.0");
    private static final Object2IntOpenHashMap<EnumPlayerPart> prevHealth = new Object2IntOpenHashMap();
    private static final EnumMap<EnumPlayerPart, FlashStateManager> flashStates = new EnumMap(EnumPlayerPart.class);

    public static void drawHealthString(PoseStack stack, AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, boolean allowSecondLine) {
        float absorption = damageablePart.getAbsorption();
        String text = TEXT_FORMAT.format(damageablePart.currentHealth) + "/" + damageablePart.getMaxHealth();
        if (absorption > 0.0f) {
            String line2 = "+ " + TEXT_FORMAT.format(absorption);
            if (allowSecondLine) {
                Minecraft.m_91087_().f_91062_.m_92750_(stack, line2, xTranslation, yTranslation + 5.0f, 0xFFFFFF);
                yTranslation -= 5.0f;
            } else {
                text = text + " " + line2;
            }
        }
        Minecraft.m_91087_().f_91062_.m_92750_(stack, text, xTranslation, yTranslation, 0xFFFFFF);
    }

    private static void updatePrev(EnumPlayerPart part, int current, boolean playerDead) {
        if (!playerDead) {
            prevHealth.put((Object)part, current);
        } else {
            prevHealth.clear();
        }
    }

    public static boolean healthChanged(AbstractDamageablePart damageablePart, boolean playerDead) {
        int current = (int)Math.ceil(damageablePart.currentHealth);
        FlashStateManager activeFlashState = Objects.requireNonNull(flashStates.get((Object)damageablePart.part));
        if (prevHealth.containsKey((Object)damageablePart.part)) {
            int prev = prevHealth.getInt((Object)damageablePart.part);
            HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
            if (prev != current) {
                activeFlashState.setActive(Util.m_137550_());
                return true;
            }
            return false;
        }
        activeFlashState.setActive(Util.m_137550_());
        HealthRenderUtils.updatePrev(damageablePart.part, current, playerDead);
        return true;
    }

    public static boolean drawAsString(AbstractDamageablePart damageablePart, boolean allowSecondLine) {
        int maxExtraHealth;
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        return maxHealth + (maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption())) > 8 && allowSecondLine || maxHealth + maxExtraHealth > 12;
    }

    public static void drawHealth(PoseStack stack, AbstractDamageablePart damageablePart, float xTranslation, float yTranslation, GuiComponent gui, boolean allowSecondLine) {
        int maxHealth = HealthRenderUtils.getMaxHearts(damageablePart.getMaxHealth());
        int maxExtraHealth = HealthRenderUtils.getMaxHearts(damageablePart.getAbsorption());
        int current = (int)Math.ceil(damageablePart.currentHealth);
        FlashStateManager activeFlashState = Objects.requireNonNull(flashStates.get((Object)damageablePart.part));
        if (HealthRenderUtils.drawAsString(damageablePart, allowSecondLine)) {
            HealthRenderUtils.drawHealthString(stack, damageablePart, xTranslation, yTranslation, allowSecondLine);
            return;
        }
        int yTexture = damageablePart.canCauseDeath ? 45 : 0;
        int absorption = (int)Math.ceil(damageablePart.getAbsorption());
        boolean highlight = activeFlashState.update(Util.m_137550_());
        Minecraft mc = Minecraft.m_91087_();
        int regen = -1;
        if (((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue() && mc.f_91074_.m_21023_(MobEffects.f_19605_)) {
            regen = mc.f_91065_.m_93079_() / 2 % 15;
        }
        boolean low = (float)(current + absorption) < 1.25f;
        RenderSystem.m_157456_((int)0, (ResourceLocation)GuiComponent.f_93098_);
        stack.m_85836_();
        stack.m_85837_((double)xTranslation, (double)yTranslation, 0.0);
        boolean drawSecondLine = allowSecondLine;
        if (allowSecondLine) {
            boolean bl = drawSecondLine = maxHealth + maxExtraHealth > 4;
        }
        if (drawSecondLine) {
            int maxHealth2 = 0;
            if (maxHealth > 4) {
                maxHealth2 = maxHealth - 4;
                maxHealth = 4;
            }
            int maxExtraHealth2 = Math.max(0, maxExtraHealth - (4 - maxHealth));
            maxExtraHealth -= maxExtraHealth2;
            int current2 = 0;
            if (current > 8) {
                current2 = current - 8;
                current = 8;
            }
            int absorption2 = absorption - maxExtraHealth * 2;
            absorption -= absorption2;
            stack.m_85837_(0.0, 5.0, 0.0);
            stack.m_85836_();
            HealthRenderUtils.renderLine(stack, regen, low, yTexture, maxHealth2, maxExtraHealth2, current2, absorption2, gui, highlight);
            regen -= maxHealth2 + maxExtraHealth;
            stack.m_85849_();
            stack.m_85837_(0.0, -10.0, 0.0);
        }
        HealthRenderUtils.renderLine(stack, regen, low, yTexture, maxHealth, maxExtraHealth, current, absorption, gui, highlight);
        stack.m_85849_();
    }

    private static void renderLine(PoseStack stack, int regen, boolean low, int yTexture, int maxHealth, int maxExtraHearts, int current, int absorption, GuiComponent gui, boolean highlight) {
        stack.m_85836_();
        Int2IntArrayMap map = new Int2IntArrayMap();
        if (low) {
            for (int i = 0; i < maxHealth + maxExtraHearts; ++i) {
                map.put(i, EventHandler.RAND.nextInt(2));
            }
        }
        HealthRenderUtils.renderMax(stack, regen, (Int2IntFunction)map, maxHealth, yTexture, gui, highlight);
        if (maxExtraHearts > 0) {
            if (maxHealth != 0) {
                stack.m_85837_((double)(2 + 9 * maxHealth), 0.0, 0.0);
            }
            HealthRenderUtils.renderMax(stack, regen - maxHealth, (Int2IntFunction)map, maxExtraHearts, yTexture, gui, false);
        }
        stack.m_85849_();
        stack.m_85837_(0.0, 0.0, 1.0);
        HealthRenderUtils.renderCurrentHealth(stack, regen, (Int2IntFunction)map, current, yTexture, gui);
        if (absorption > 0) {
            int offset = maxHealth * 9 + (maxHealth == 0 ? 0 : 2);
            stack.m_85837_((double)offset, 0.0, 0.0);
            HealthRenderUtils.renderAbsorption(stack, regen - maxHealth, (Int2IntFunction)map, absorption, yTexture, gui);
        }
    }

    public static int getMaxHearts(float value) {
        int maxCurrentHearts = (int)Math.ceil(value);
        if (maxCurrentHearts % 2 != 0) {
            ++maxCurrentHearts;
        }
        return maxCurrentHearts >> 1;
    }

    private static void renderMax(PoseStack stack, int regen, Int2IntFunction function, int max, int yTexture, GuiComponent gui, boolean highlight) {
        int BACKGROUND = highlight ? 25 : 16;
        HealthRenderUtils.renderTexturedModalRects(stack, regen, function, max, false, BACKGROUND, BACKGROUND, yTexture, gui);
    }

    private static void renderCurrentHealth(PoseStack stack, int regen, Int2IntFunction function, int current, int yTexture, GuiComponent gui) {
        boolean renderLastHalf = false;
        int render = current >> 1;
        if (current % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        HealthRenderUtils.renderTexturedModalRects(stack, regen, function, render, renderLastHalf, 61, 52, yTexture, gui);
    }

    private static void renderAbsorption(PoseStack stack, int regen, Int2IntFunction function, int absorption, int yTexture, GuiComponent gui) {
        boolean renderLastHalf = false;
        int render = absorption >> 1;
        if (absorption % 2 != 0) {
            renderLastHalf = true;
            ++render;
        }
        if (render > 0) {
            HealthRenderUtils.renderTexturedModalRects(stack, regen, function, render, renderLastHalf, 169, 160, yTexture, gui);
        }
    }

    private static void renderTexturedModalRects(PoseStack stack, int regen, Int2IntFunction function, int toDraw, boolean lastOneHalf, int halfTextureX, int textureX, int textureY, GuiComponent gui) {
        if (toDraw == 0) {
            return;
        }
        if (toDraw < 0) {
            throw new IllegalArgumentException("Cannot draw negative amount of icons " + toDraw);
        }
        for (int i = 0; i < toDraw; ++i) {
            boolean renderHalf = lastOneHalf && i + 1 == toDraw;
            gui.m_93228_(stack, (int)(9.0f * (float)i), (i == regen ? -2 : 0) - function.get(i), renderHalf ? halfTextureX : textureX, textureY, 9, 9);
        }
    }

    static {
        for (EnumPlayerPart part : EnumPlayerPart.VALUES) {
            flashStates.put(part, new FlashStateManager());
        }
    }
}

