/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.client.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.client.util.EventCalendar;
import java.util.Random;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.resources.ResourceLocation;

public class PlayerModelRenderer {
    private static final ResourceLocation HEALTH_RENDER_LOCATION = new ResourceLocation("firstaid", "textures/gui/simple_health.png");
    private static final Random RANDOM = new Random();
    private static final int SIZE = 32;
    private static int angle = 0;
    private static boolean otherWay = false;
    private static int cooldown = 0;

    public static void renderPlayerHealth(PoseStack stack, AbstractPlayerDamageModel damageModel, boolean fourColors, GuiComponent gui, boolean flashState, float alpha, float partialTicks) {
        int yOffset = flashState ? 64 : 0;
        RenderSystem.m_69478_();
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)(1.0f - alpha / 255.0f));
        RenderSystem.m_157456_((int)0, (ResourceLocation)HEALTH_RENDER_LOCATION);
        if (((Boolean)FirstAidConfig.CLIENT.enableEasterEggs.get()).booleanValue() && (EventCalendar.isAFDay() || EventCalendar.isHalloween())) {
            float angle = PlayerModelRenderer.angle;
            if (cooldown == 0) {
                angle += (otherWay ? -partialTicks : partialTicks) * 2.0f;
            }
            if (FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.BOTTOM_LEFT || FirstAidConfig.CLIENT.pos.get() == FirstAidConfig.Client.Position.TOP_LEFT) {
                stack.m_85837_((double)(angle * 1.5f), 0.0, 0.0);
            } else {
                stack.m_85837_((double)(angle * 0.5f), 0.0, 0.0);
            }
            stack.m_85845_(Vector3f.f_122227_.m_122240_(angle));
        }
        if (yOffset != 0) {
            stack.m_85837_(0.0, (double)(-yOffset), 0.0);
        }
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.HEAD, 8, yOffset + 0, 16, 16);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.BODY, 8, yOffset + 16, 16, 24);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.LEFT_ARM, 0, yOffset + 16, 8, 24);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.RIGHT_ARM, 24, yOffset + 16, 8, 24);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.LEFT_LEG, 8, yOffset + 40, 8, 16);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.RIGHT_LEG, 16, yOffset + 40, 8, 16);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.LEFT_FOOT, 8, yOffset + 56, 8, 8);
        PlayerModelRenderer.drawPart(stack, gui, fourColors, damageModel.RIGHT_FOOT, 16, yOffset + 56, 8, 8);
        RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    private static void drawPart(PoseStack stack, GuiComponent gui, boolean fourColors, AbstractDamageablePart part, int texX, int texY, int sizeX, int sizeY) {
        int rawTexX = texX;
        gui.m_93228_(stack, rawTexX, texY, texX += 32 * PlayerModelRenderer.getState(part, fourColors), texY, sizeX, sizeY);
    }

    private static int getState(AbstractDamageablePart part, boolean fourColors) {
        if (part.currentHealth <= 0.001f) {
            return 5;
        }
        int maxHealth = part.getMaxHealth();
        if (Math.abs(part.currentHealth - (float)maxHealth) < 0.001f) {
            return 0;
        }
        float healthPercentage = part.currentHealth / (float)maxHealth;
        if (healthPercentage >= 1.0f || healthPercentage <= 0.0f) {
            throw new RuntimeException(String.format("Calculated invalid health for part %s with current health %s and max health %d. Got value %s", new Object[]{part.part, Float.valueOf(part.currentHealth), maxHealth, Float.valueOf(healthPercentage)}));
        }
        if (!fourColors && healthPercentage > 0.75f) {
            return 1;
        }
        if (healthPercentage > 0.5f) {
            return 2;
        }
        if (!fourColors && healthPercentage > 0.25f) {
            return 3;
        }
        return 4;
    }

    public static void tickFun() {
        if (cooldown > 0) {
            --cooldown;
            return;
        }
        if ((angle += otherWay ? -2 : 2) >= 90 || angle <= 0) {
            boolean bl = otherWay = !otherWay;
            if (!otherWay) {
                int multiplier = EventCalendar.isHalloween() ? 10 : 1;
                cooldown = (200 + RANDOM.nextInt(400)) * multiplier;
            } else {
                int multiplier = EventCalendar.isHalloween() ? 2 : 1;
                cooldown = (30 + RANDOM.nextInt(60)) * multiplier;
            }
        }
    }
}

