/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.item.ItemHealing;
import ichttt.mods.firstaid.common.damagesystem.PartHealer;
import ichttt.mods.firstaid.common.items.ItemMorphine;
import ichttt.mods.firstaid.common.potion.FirstAidPotion;
import ichttt.mods.firstaid.common.potion.PotionPoisonPatched;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class RegistryObjects {
    private static final DeferredRegister<Item> ITEM_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"firstaid");
    private static final DeferredRegister<SoundEvent> SOUND_EVENT_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"firstaid");
    private static final DeferredRegister<MobEffect> MOB_EFFECT_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"firstaid");
    private static final DeferredRegister<MobEffect> MOB_EFFECT_OVERRIDE_REGISTER = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"minecraft");
    public static final RegistryObject<Item> BANDAGE;
    public static final RegistryObject<Item> PLASTER;
    public static final RegistryObject<Item> MORPHINE;
    public static final RegistryObject<SoundEvent> HEARTBEAT;
    public static final RegistryObject<MobEffect> MORPHINE_EFFECT;
    public static final RegistryObject<MobEffect> POISON_PATCHED;

    public static void registerToBus(IEventBus bus) {
        ITEM_REGISTER.register(bus);
        SOUND_EVENT_REGISTER.register(bus);
        MOB_EFFECT_REGISTER.register(bus);
        MOB_EFFECT_OVERRIDE_REGISTER.register(bus);
    }

    static {
        FirstAidConfig.Server server = FirstAidConfig.SERVER;
        BANDAGE = ITEM_REGISTER.register("bandage", () -> ItemHealing.create(new Item.Properties().m_41487_(16), stack -> new PartHealer(() -> (Integer)server.bandage.secondsPerHeal.get() * 20, () -> ((ForgeConfigSpec.IntValue)server.bandage.totalHeals).get(), (ItemStack)stack), stack -> (Integer)server.bandage.applyTime.get()));
        PLASTER = ITEM_REGISTER.register("plaster", () -> ItemHealing.create(new Item.Properties().m_41487_(16), stack -> new PartHealer(() -> (Integer)server.plaster.secondsPerHeal.get() * 20, () -> ((ForgeConfigSpec.IntValue)server.plaster.totalHeals).get(), (ItemStack)stack), stack -> (Integer)server.plaster.applyTime.get()));
        MORPHINE = ITEM_REGISTER.register("morphine", ItemMorphine::new);
        ResourceLocation soundLocation = new ResourceLocation("firstaid", "debuff.heartbeat");
        HEARTBEAT = SOUND_EVENT_REGISTER.register(soundLocation.m_135815_(), () -> new SoundEvent(soundLocation));
        MORPHINE_EFFECT = MOB_EFFECT_REGISTER.register("morphine", () -> new FirstAidPotion(MobEffectCategory.BENEFICIAL, 3549));
        POISON_PATCHED = MOB_EFFECT_OVERRIDE_REGISTER.register("poison", () -> new PotionPoisonPatched(MobEffectCategory.HARMFUL, 5149489));
    }
}

