/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.compat.playerrevive;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.compat.playerrevive.IPRCompatHandler;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import team.creative.playerrevive.api.IBleeding;

public class PRPresentCompatHandler
implements IPRCompatHandler {
    private static final Capability<IBleeding> BLEEDING_CAP = CapabilityManager.get((CapabilityToken)new CapabilityToken<IBleeding>(){});

    public static boolean canUse() {
        return BLEEDING_CAP != null;
    }

    private static IBleeding getBleedingCapIfPossible(Player player) {
        if (player == null) {
            return null;
        }
        MinecraftServer server = player.m_20194_();
        if (server == null) {
            return null;
        }
        LazyOptional bleeding = player.getCapability(BLEEDING_CAP);
        if (bleeding.isPresent() && server.m_6992_()) {
            return (IBleeding)bleeding.orElseThrow(RuntimeException::new);
        }
        return null;
    }

    @Override
    public boolean tryRevivePlayer(Player player, DamageSource source) {
        IBleeding bleedingCap = PRPresentCompatHandler.getBleedingCapIfPossible(player);
        if (bleedingCap != null) {
            bleedingCap.knockOut(player, source);
            return true;
        }
        return false;
    }

    @Override
    public boolean isBleeding(Player player) {
        IBleeding revival = PRPresentCompatHandler.getBleedingCapIfPossible(player);
        if (revival != null) {
            return revival.isBleeding() && revival.timeLeft() > 0;
        }
        return false;
    }

    static {
        FirstAid.LOGGER.info("Initializing PlayerRevive Compatibility...");
        if (BLEEDING_CAP == null) {
            FirstAid.LOGGER.warn("Failed to find player revive bleeding capability!");
        }
    }
}

