/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.distribution;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.RegistryObjects;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.ArmorUtils;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;
import net.minecraftforge.network.PacketDistributor;

public class EqualDamageDistribution
implements IDamageDistribution {
    private static final Method applyPotionDamageCalculationsMethod = ObfuscationReflectionHelper.findMethod(LivingEntity.class, (String)"m_6515_", (Class[])new Class[]{DamageSource.class, Float.TYPE});
    private final boolean tryNoKill;
    private final float reductionMultiplier;

    public EqualDamageDistribution(boolean tryNoKill, float reductionMultiplier) {
        this.tryNoKill = tryNoKill;
        this.reductionMultiplier = reductionMultiplier;
    }

    private float reduceDamage(float originalDamage, Player player, DamageSource source) {
        float damage = originalDamage;
        for (EquipmentSlot slot : CommonUtils.ARMOR_SLOTS) {
            ItemStack armor = player.m_6844_(slot);
            damage = ArmorUtils.applyArmor(player, armor, source, damage, slot);
            if (!(damage <= 0.0f)) continue;
            return 0.0f;
        }
        try {
            damage = ((Float)applyPotionDamageCalculationsMethod.invoke((Object)player, source, Float.valueOf(damage))).floatValue();
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            FirstAid.LOGGER.error("Could not invoke applyPotionDamageCalculations!", (Throwable)e);
        }
        if (damage <= 0.0f) {
            return 0.0f;
        }
        float reduction = originalDamage - damage;
        if (reduction > 0.0f) {
            reduction *= this.reductionMultiplier;
        }
        if ((damage = originalDamage - reduction) <= 0.0f) {
            return 0.0f;
        }
        damage = ForgeHooks.onLivingDamage((LivingEntity)player, (DamageSource)source, (float)damage);
        return damage;
    }

    private float distributeOnParts(float damage, AbstractPlayerDamageModel damageModel, Player player, boolean tryNoKillThisRound) {
        float prevDamageLeft;
        int iterationCounter = 0;
        int divCount = EnumPlayerPart.VALUES.length;
        float damageLeft = damage;
        do {
            prevDamageLeft = damageLeft;
            float toDamage = damageLeft / (float)divCount;
            divCount = 0;
            damageLeft = 0.0f;
            for (AbstractDamageablePart part : damageModel) {
                if (!(part.currentHealth > 0.0f)) continue;
                damageLeft += part.damage(toDamage, player, !player.m_21023_((MobEffect)RegistryObjects.MORPHINE_EFFECT.get()), tryNoKillThisRound ? 1.0f : 0.0f);
                ++divCount;
            }
            if (iterationCounter >= 50) {
                FirstAid.LOGGER.warn("Not done distribution equally after 50 rounds, diff {}. Dropping!", (Object)Float.valueOf(Math.abs(prevDamageLeft - damageLeft)));
                break;
            }
            ++iterationCounter;
        } while (prevDamageLeft != damageLeft);
        return damageLeft;
    }

    @Override
    public float distributeDamage(float damage, @Nonnull Player player, @Nonnull DamageSource source, boolean addStat) {
        if ((damage = this.reduceDamage(damage, player, source)) <= 0.0f) {
            return 0.0f;
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel(player);
        Objects.requireNonNull(damageModel);
        float damageLeft = this.distributeOnParts(damage, damageModel, player, this.tryNoKill);
        if (damageLeft > 0.0f && this.tryNoKill) {
            damageLeft = this.distributeOnParts(damage, damageModel, player, false);
        }
        FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(damageModel, false));
        float effectiveDmg = damage - damageLeft;
        if (effectiveDmg < 3.4028235E37f) {
            player.m_36222_(Stats.f_12931_, Math.round(effectiveDmg * 10.0f));
        }
        return damageLeft;
    }

    @Override
    public boolean skipGlobalPotionModifiers() {
        return true;
    }
}

