/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.util;

import com.google.common.primitives.Ints;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.CapabilityExtendedHealthSystem;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.SynchedEntityDataWrapper;
import ichttt.mods.firstaid.common.compat.playerrevive.IPRCompatHandler;
import ichttt.mods.firstaid.common.compat.playerrevive.PRCompatManager;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class CommonUtils {
    @Nonnull
    public static final EquipmentSlot[] ARMOR_SLOTS = new EquipmentSlot[4];
    @Nonnull
    private static final Map<EquipmentSlot, List<EnumPlayerPart>> SLOT_TO_PARTS;

    public static List<EnumPlayerPart> getPartListForSlot(EquipmentSlot slot) {
        return new ArrayList<EnumPlayerPart>((Collection)SLOT_TO_PARTS.get(slot));
    }

    public static EnumPlayerPart[] getPartArrayForSlot(EquipmentSlot slot) {
        return CommonUtils.getPartListForSlot(slot).toArray(new EnumPlayerPart[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void killPlayer(@Nonnull AbstractPlayerDamageModel damageModel, @Nonnull Player player, @Nullable DamageSource source) {
        IPRCompatHandler handler;
        if (player.f_19853_.f_46443_) {
            try {
                throw new RuntimeException("Tried to kill the player on the client!");
            }
            catch (RuntimeException e) {
                FirstAid.LOGGER.warn("Tried to kill the player on the client! This should only happen on the server! Ignoring...", (Throwable)e);
            }
        }
        SynchedEntityDataWrapper wrapper = (SynchedEntityDataWrapper)player.f_19804_;
        if (source != null && ((Boolean)FirstAidConfig.SERVER.allowOtherHealingItems.get()).booleanValue()) {
            boolean protection;
            wrapper.toggleTracking(false);
            try {
                protection = player.m_21262_(source);
            }
            finally {
                wrapper.toggleTracking(true);
            }
            if (protection) {
                for (AbstractDamageablePart part : damageModel) {
                    if (!part.canCauseDeath) continue;
                    part.currentHealth = Math.max(part.currentHealth, 1.0f);
                }
                if (player instanceof ServerPlayer) {
                    FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(damageModel, false));
                }
                return;
            }
        }
        if (!(handler = PRCompatManager.getHandler()).tryRevivePlayer(player, source)) {
            wrapper.set_impl(Player.f_20961_, Float.valueOf(0.0f));
        } else {
            wrapper.toggleBeingRevived(true);
        }
    }

    public static boolean isValidArmorSlot(EquipmentSlot slot) {
        return slot.m_20743_() == EquipmentSlot.Type.ARMOR;
    }

    @Nonnull
    public static String getActiveModidSafe() {
        ModContainer activeModContainer = ModLoadingContext.get().getActiveContainer();
        return activeModContainer == null ? "UNKNOWN-NULL" : activeModContainer.getModId();
    }

    public static void healPlayerByPercentage(double percentage, AbstractPlayerDamageModel damageModel, Player player) {
        Objects.requireNonNull(damageModel);
        int healValue = Ints.checkedCast((long)Math.round((double)damageModel.getCurrentMaxHealth() * percentage));
        HealthDistribution.manageHealth(healValue, damageModel, player, true, false);
    }

    public static void debugLogStacktrace(String name) {
        if (!((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            return;
        }
        try {
            throw new RuntimeException("DEBUG:" + name);
        }
        catch (RuntimeException e) {
            FirstAid.LOGGER.info("DEBUG: " + name, (Throwable)e);
            return;
        }
    }

    @Nonnull
    public static AbstractPlayerDamageModel getDamageModel(Player player) {
        return (AbstractPlayerDamageModel)CommonUtils.getOptionalDamageModel(player).orElseThrow(() -> new IllegalArgumentException("Player " + player.m_7755_().m_214077_() + " is missing a damage model!"));
    }

    @Nonnull
    public static LazyOptional<AbstractPlayerDamageModel> getOptionalDamageModel(Player player) {
        return player.getCapability(CapabilityExtendedHealthSystem.INSTANCE);
    }

    public static boolean hasDamageModel(Entity entity) {
        return entity instanceof Player && !(entity instanceof FakePlayer);
    }

    @Nonnull
    public static ServerPlayer checkServer(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_SERVER) {
            throw new IllegalArgumentException("Wrong side for server packet handler " + context.getDirection());
        }
        context.setPacketHandled(true);
        return Objects.requireNonNull(context.getSender());
    }

    public static void checkClient(NetworkEvent.Context context) {
        if (context.getDirection() != NetworkDirection.PLAY_TO_CLIENT) {
            throw new IllegalArgumentException("Wrong side for client packet handler: " + context.getDirection());
        }
        context.setPacketHandled(true);
    }

    static {
        CommonUtils.ARMOR_SLOTS[3] = EquipmentSlot.HEAD;
        CommonUtils.ARMOR_SLOTS[2] = EquipmentSlot.CHEST;
        CommonUtils.ARMOR_SLOTS[1] = EquipmentSlot.LEGS;
        CommonUtils.ARMOR_SLOTS[0] = EquipmentSlot.FEET;
        SLOT_TO_PARTS = new EnumMap<EquipmentSlot, List<EnumPlayerPart>>(EquipmentSlot.class);
        SLOT_TO_PARTS.put(EquipmentSlot.HEAD, Collections.singletonList(EnumPlayerPart.HEAD));
        SLOT_TO_PARTS.put(EquipmentSlot.CHEST, Arrays.asList(EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM, EnumPlayerPart.BODY));
        SLOT_TO_PARTS.put(EquipmentSlot.LEGS, Arrays.asList(EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG));
        SLOT_TO_PARTS.put(EquipmentSlot.FEET, Arrays.asList(EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT));
    }
}

