/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.api.enums;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.world.entity.EquipmentSlot;

public enum EnumPlayerPart {
    HEAD(EquipmentSlot.HEAD),
    LEFT_ARM(EquipmentSlot.CHEST),
    LEFT_LEG(EquipmentSlot.LEGS),
    LEFT_FOOT(EquipmentSlot.FEET),
    BODY(EquipmentSlot.CHEST),
    RIGHT_ARM(EquipmentSlot.CHEST),
    RIGHT_LEG(EquipmentSlot.LEGS),
    RIGHT_FOOT(EquipmentSlot.FEET);

    public static final EnumPlayerPart[] VALUES;
    private ImmutableList<EnumPlayerPart> neighbours;
    public final EquipmentSlot slot;

    private EnumPlayerPart(EquipmentSlot slot) {
        this.slot = slot;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ImmutableList<EnumPlayerPart> getNeighbours() {
        if (this.neighbours == null) {
            EnumPlayerPart enumPlayerPart = this;
            synchronized (enumPlayerPart) {
                if (this.neighbours == null) {
                    ImmutableList.Builder builder = ImmutableList.builder();
                    builder.addAll(this.getNeighboursDown());
                    builder.addAll(this.getNeighboursUp());
                    builder.addAll(this.getNeighboursLeft());
                    builder.addAll(this.getNeighboursRight());
                    this.neighbours = builder.build();
                }
            }
        }
        return this.neighbours;
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursUp() {
        switch (this) {
            case BODY: {
                return Collections.singletonList(HEAD);
            }
            case LEFT_LEG: 
            case RIGHT_LEG: {
                return Collections.singletonList(BODY);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(RIGHT_LEG);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursDown() {
        switch (this) {
            case HEAD: {
                return Collections.singletonList(BODY);
            }
            case BODY: {
                return Arrays.asList(LEFT_LEG, RIGHT_LEG);
            }
            case LEFT_LEG: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(RIGHT_FOOT);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursLeft() {
        switch (this) {
            case RIGHT_ARM: {
                return Collections.singletonList(BODY);
            }
            case RIGHT_LEG: {
                return Collections.singletonList(LEFT_LEG);
            }
            case RIGHT_FOOT: {
                return Collections.singletonList(LEFT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(LEFT_ARM);
            }
        }
        return Collections.emptyList();
    }

    @Nonnull
    private List<EnumPlayerPart> getNeighboursRight() {
        switch (this) {
            case LEFT_ARM: {
                return Collections.singletonList(BODY);
            }
            case LEFT_LEG: {
                return Collections.singletonList(RIGHT_LEG);
            }
            case LEFT_FOOT: {
                return Collections.singletonList(RIGHT_FOOT);
            }
            case BODY: {
                return Collections.singletonList(RIGHT_ARM);
            }
        }
        return Collections.emptyList();
    }

    static {
        for (EnumPlayerPart value : VALUES = EnumPlayerPart.values()) {
            ImmutableList<EnumPlayerPart> neighbours = value.getNeighbours();
            if (neighbours.contains((Object)value)) {
                throw new RuntimeException(value + " contains itself as a neighbour!");
            }
            if (neighbours.isEmpty()) {
                throw new RuntimeException(value + " does not have any neighbours!");
            }
            if (EnumSet.copyOf(neighbours).size() != neighbours.size()) {
                throw new RuntimeException(value + " neighbours contain the same part multiple times!");
            }
            EnumSet<EnumPlayerPart> hopefullyAllParts = EnumSet.copyOf(neighbours);
            int oldSize = -1;
            while (oldSize != hopefullyAllParts.size()) {
                oldSize = hopefullyAllParts.size();
                EnumSet<EnumPlayerPart> neighboursOfNeighbours = EnumSet.noneOf(EnumPlayerPart.class);
                for (EnumPlayerPart part : hopefullyAllParts) {
                    neighboursOfNeighbours.addAll((Collection<EnumPlayerPart>)part.getNeighbours());
                }
                hopefullyAllParts.addAll(neighboursOfNeighbours);
            }
            if (hopefullyAllParts.size() == VALUES.length) continue;
            throw new RuntimeException(value + " could not read all player parts " + Arrays.toString((Object[])hopefullyAllParts.toArray(new EnumPlayerPart[0])));
        }
    }
}

