/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.api.event;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.distribution.DamageDistributionBuilderFactory;
import ichttt.mods.firstaid.api.event.FirstAidRegisterEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;

public class RegisterDamageDistributionEvent
extends FirstAidRegisterEvent {
    private final DamageDistributionBuilderFactory distributionBuilderFactory;
    private final ArrayList<Pair<Predicate<DamageSource>, IDamageDistribution>> distributionsDynamic = new ArrayList();
    private final Map<ResourceKey<DamageType>, IDamageDistribution> distributionsStatic = new HashMap<ResourceKey<DamageType>, IDamageDistribution>();

    public RegisterDamageDistributionEvent(Level level, DamageDistributionBuilderFactory distributionBuilderFactory) {
        super(level);
        this.distributionBuilderFactory = distributionBuilderFactory;
    }

    public DamageDistributionBuilderFactory getDistributionBuilderFactory() {
        return this.distributionBuilderFactory;
    }

    public void registerDamageDistributionDynamic(IDamageDistribution distribution, Predicate<DamageSource> matcher) {
        this.distributionsDynamic.add((Pair<Predicate<DamageSource>, IDamageDistribution>)Pair.of(matcher, (Object)distribution));
    }

    public void registerDamageDistributionStatic(IDamageDistribution distribution, DamageSource ... sources) {
        for (DamageSource damageSource : sources) {
            IDamageDistribution oldDistribution = this.distributionsStatic.put((ResourceKey<DamageType>)((ResourceKey)damageSource.m_269150_().m_203543_().orElseThrow(() -> new RuntimeException("Attempted to register a distribution for an unregistered damage source"))), distribution);
            if (oldDistribution == null) continue;
            FirstAid.LOGGER.info("Damage Distribution override detected for source {} ({}), was {}, is {}", (Object)damageSource, (Object)damageSource.m_269415_().f_268677_(), (Object)oldDistribution, (Object)distribution);
        }
    }

    public Map<ResourceKey<DamageType>, IDamageDistribution> getDistributionsStatic() {
        return Collections.unmodifiableMap(this.distributionsStatic);
    }

    public List<Pair<Predicate<DamageSource>, IDamageDistribution>> getDistributionsDynamic() {
        this.distributionsDynamic.trimToSize();
        return Collections.unmodifiableList(this.distributionsDynamic);
    }
}

