/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.DirectDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class DebugDamageCommand {
    private static final SimpleCommandExceptionType TYPE = new SimpleCommandExceptionType((Message)Component.m_237113_((String)"0 is invalid as damage"));

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.m_82127_((String)"damagePart").requires(source -> source.m_6761_(2));
        ArrayList<EnumPlayerPart> allowedValues = new ArrayList<EnumPlayerPart>(Arrays.asList(EnumPlayerPart.VALUES));
        allowedValues.add(null);
        for (EnumPlayerPart part : allowedValues) {
            builder.then(Commands.m_82127_((String)(part == null ? "ALL" : part.name())).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"damage", (ArgumentType)FloatArgumentType.floatArg()).executes(context -> DebugDamageCommand.handleCommand(part, FloatArgumentType.getFloat((CommandContext)context, (String)"damage"), true, ((CommandSourceStack)context.getSource()).m_81375_()))).then(Commands.m_82127_((String)"nodebuff").executes(context -> DebugDamageCommand.handleCommand(part, FloatArgumentType.getFloat((CommandContext)context, (String)"damage"), false, ((CommandSourceStack)context.getSource()).m_81375_())))));
        }
        dispatcher.register(builder);
    }

    private static int handleCommand(EnumPlayerPart part, float damage, boolean debuff, ServerPlayer player) throws CommandSyntaxException {
        if (damage == 0.0f) {
            throw TYPE.create();
        }
        AbstractPlayerDamageModel damageModel = CommonUtils.getDamageModel((Player)player);
        if (part == null) {
            for (EnumPlayerPart aPart : EnumPlayerPart.VALUES) {
                DebugDamageCommand.doDamage(aPart, damage, debuff, player, damageModel);
            }
        } else {
            DebugDamageCommand.doDamage(part, damage, debuff, player, damageModel);
        }
        FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSyncDamageModel(damageModel, false));
        return 1;
    }

    private static void doDamage(EnumPlayerPart part, float damage, boolean debuff, ServerPlayer player, AbstractPlayerDamageModel damageModel) {
        if (damage > 0.0f) {
            DamageDistribution.handleDamageTaken(new DirectDamageDistribution(part, debuff), damageModel, damage, (Player)player, player.m_269291_().m_269341_(), false, false);
        } else {
            damageModel.getFromEnum(part).heal(-damage, (Player)player, debuff);
        }
        if (damageModel.isDead((Player)player)) {
            player.m_213846_((Component)Component.m_237110_((String)"death.attack.generic", (Object[])new Object[]{player.m_5446_()}));
            CommonUtils.killPlayer(damageModel, (Player)player, null);
        }
    }
}

