/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.common.damagesystem.distribution.DamageDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.HealthDistribution;
import ichttt.mods.firstaid.common.damagesystem.distribution.RandomDamageDistribution;
import ichttt.mods.firstaid.common.network.MessageApplyAbsorption;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.PacketDistributor;

public class SynchedEntityDataWrapper
extends SynchedEntityData {
    private final Player player;
    private final SynchedEntityData parent;
    private boolean track = true;
    private boolean beingRevived = false;

    public SynchedEntityDataWrapper(Player player, SynchedEntityData parent) {
        super((Entity)player);
        this.player = player;
        this.parent = parent;
    }

    @Nonnull
    public <T> T m_135370_(@Nonnull EntityDataAccessor<T> key) {
        if (key == Player.f_36107_ && this.player.m_6084_()) {
            this.parent.m_135381_(key, (Object)CommonUtils.getDamageModel(this.player).getAbsorption());
        }
        return (T)this.parent.m_135370_(key);
    }

    public <T> void set_impl(@Nonnull EntityDataAccessor<T> key, @Nonnull T value) {
        this.parent.m_135381_(key, value);
    }

    public <T> void m_135381_(@Nonnull EntityDataAccessor<T> key, @Nonnull T value) {
        if (!this.track) {
            if (key != LivingEntity.f_20961_) {
                this.set_impl(key, value);
            }
            return;
        }
        if (key == Player.f_36107_) {
            float floatValue = ((Float)value).floatValue();
            if (this.player instanceof ServerPlayer) {
                ServerPlayer playerMP = (ServerPlayer)this.player;
                if (playerMP.f_8906_ != null) {
                    FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> playerMP), (Object)new MessageApplyAbsorption(floatValue));
                }
            }
            CommonUtils.getDamageModel(this.player).setAbsorption(floatValue);
        } else if (key == LivingEntity.f_20961_ && value instanceof Float && !this.player.f_19853_.f_46443_) {
            float aFloat = ((Float)value).floatValue();
            if (aFloat > this.player.m_21233_()) {
                CommonUtils.getDamageModel(this.player).forEach(damageablePart -> {
                    damageablePart.currentHealth = damageablePart.getMaxHealth();
                });
            } else {
                float orig;
                if (this.beingRevived) {
                    if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                        CommonUtils.debugLogStacktrace("Completely ignoring setHealth!");
                    }
                    return;
                }
                if (!Float.isInfinite(aFloat) && !Float.isNaN(aFloat) && aFloat > 0.0f && this.player instanceof ServerPlayer && ((ServerPlayer)this.player).f_8906_ != null && (orig = ((Float)this.m_135370_(LivingEntity.f_20961_)).floatValue()) > 0.0f && !Float.isNaN(orig) && !Float.isInfinite(orig)) {
                    float healed;
                    if (((Boolean)FirstAidConfig.SERVER.scaleMaxHealth.get()).booleanValue()) {
                        orig = Math.min(orig, (float)this.player.m_21051_(Attributes.f_22276_).m_22135_());
                    }
                    if ((double)Math.abs(healed = aFloat - orig) > 0.001) {
                        if (healed < 0.0f) {
                            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                                CommonUtils.debugLogStacktrace("DAMAGING: " + -healed);
                            }
                            DamageDistribution.handleDamageTaken(RandomDamageDistribution.getDefault(), CommonUtils.getDamageModel(this.player), -healed, this.player, this.player.m_269291_().m_269425_(), true, true);
                        } else {
                            if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                                CommonUtils.debugLogStacktrace("HEALING: " + healed);
                            }
                            HealthDistribution.addRandomHealth(healed, this.player, true);
                        }
                    }
                    return;
                }
            }
        }
        this.set_impl(key, value);
    }

    public void toggleTracking(boolean status) {
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            CommonUtils.debugLogStacktrace("Tracking status change from " + this.track + " to " + status);
        }
        this.track = status;
    }

    public void toggleBeingRevived(boolean status) {
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            CommonUtils.debugLogStacktrace("Revived status change from " + this.beingRevived + " to " + status);
        }
        this.beingRevived = status;
    }

    public <T> void m_135372_(EntityDataAccessor<T> pKey, T pValue) {
        this.parent.m_135372_(pKey, pValue);
    }

    public <T> SynchedEntityData.DataItem<T> m_135379_(EntityDataAccessor<T> pKey) {
        return this.parent.m_135379_(pKey);
    }

    public boolean m_135352_() {
        return this.parent.m_135352_();
    }

    @Nullable
    public List<SynchedEntityData.DataValue<?>> m_135378_() {
        return this.parent.m_135378_();
    }

    @Nullable
    public List<SynchedEntityData.DataValue<?>> m_252804_() {
        return this.parent.m_252804_();
    }

    public void m_135356_(List<SynchedEntityData.DataValue<?>> pEntries) {
        this.parent.m_135356_(pEntries);
    }

    public boolean m_135388_() {
        return this.parent.m_135388_();
    }
}

