/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.base.Preconditions;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.debuff.IDebuffBuilder;
import ichttt.mods.firstaid.common.damagesystem.debuff.ConstantDebuff;
import ichttt.mods.firstaid.common.damagesystem.debuff.OnHitDebuff;
import ichttt.mods.firstaid.common.util.CommonUtils;
import it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.sounds.SoundEvent;

public class DebuffBuilder
implements IDebuffBuilder {
    @Nonnull
    public final String potionName;
    @Nonnull
    public final Float2IntLinkedOpenHashMap map = new Float2IntLinkedOpenHashMap();
    public final boolean isOnHit;
    @Nullable
    public Supplier<SoundEvent> sound;
    @Nullable
    public BooleanSupplier isEnabledSupplier;

    public DebuffBuilder(@Nonnull String potionName, boolean isOnHit) {
        this.potionName = Objects.requireNonNull(potionName);
        this.isOnHit = isOnHit;
    }

    @Override
    @Nonnull
    public DebuffBuilder addSoundEffect(@Nullable Supplier<SoundEvent> event) {
        this.sound = event;
        return this;
    }

    @Override
    @Nonnull
    public DebuffBuilder addBound(float value, int multiplier) {
        this.map.put(value, multiplier);
        return this;
    }

    @Override
    @Nonnull
    public DebuffBuilder addEnableCondition(@Nullable BooleanSupplier isEnabled) {
        this.isEnabledSupplier = isEnabled;
        return this;
    }

    @Override
    public Supplier<IDebuff> build() {
        Supplier<IDebuff> debuff;
        FirstAid.LOGGER.debug("Building debuff from mod {} with potion effect {}, type = {}", (Object)CommonUtils.getActiveModidSafe(), (Object)this.potionName, (Object)(this.isOnHit ? "OnHit" : "Constant"));
        BooleanSupplier isEnabled = this.isEnabledSupplier == null ? () -> true : this.isEnabledSupplier;
        Preconditions.checkArgument((!this.map.isEmpty() ? 1 : 0) != 0, (Object)"Failed to register debuff with condition has set");
        if (this.isOnHit) {
            debuff = () -> new OnHitDebuff(this.potionName, this.map, isEnabled, this.sound);
        } else {
            Preconditions.checkArgument((this.sound == null ? 1 : 0) != 0, (Object)"Tried to register constant debuff with sound effect.");
            debuff = () -> new ConstantDebuff(this.potionName, this.map, isEnabled);
        }
        return debuff;
    }
}

