/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.collect.Multimap;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.IDamageDistribution;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.tuple.Pair;

public class FirstAidRegistryImpl
extends FirstAidRegistry {
    private final List<Pair<Predicate<DamageSource>, IDamageDistribution>> distributionsDynamic;
    private final Map<ResourceKey<DamageType>, IDamageDistribution> distributionsStatic;
    private final Map<Item, Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>>> healerMap;
    private final Multimap<EnumDebuffSlot, Supplier<IDebuff>> debuffs;

    public FirstAidRegistryImpl(List<Pair<Predicate<DamageSource>, IDamageDistribution>> distributionsDynamic, Map<ResourceKey<DamageType>, IDamageDistribution> distributionsStatic, Map<Item, Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>>> healerMap, Multimap<EnumDebuffSlot, Supplier<IDebuff>> debuffs) {
        this.distributionsDynamic = distributionsDynamic;
        this.distributionsStatic = distributionsStatic;
        this.healerMap = healerMap;
        this.debuffs = debuffs;
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            FirstAid.LOGGER.info("REG READOUT:");
            for (Map.Entry<ResourceKey<DamageType>, IDamageDistribution> entry : distributionsStatic.entrySet()) {
                FirstAid.LOGGER.info("{} bound to {}", entry.getKey(), (Object)entry.getValue());
            }
            FirstAid.LOGGER.info("+{} additional dynamic distributions", (Object)distributionsDynamic.size());
        }
    }

    @Override
    @Nullable
    public AbstractPartHealer getPartHealer(@Nonnull ItemStack type) {
        Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>> pair = this.healerMap.get(type.m_41720_());
        if (pair != null) {
            return (AbstractPartHealer)((Function)pair.getLeft()).apply(type);
        }
        return null;
    }

    @Override
    public Integer getPartHealingTime(@Nonnull ItemStack stack) {
        Pair<Function<ItemStack, AbstractPartHealer>, Function<ItemStack, Integer>> pair = this.healerMap.get(stack.m_41720_());
        if (pair != null) {
            return (Integer)((Function)pair.getRight()).apply(stack);
        }
        return null;
    }

    @Override
    @Nullable
    public IDamageDistribution getDamageDistributionForSource(@Nonnull DamageSource source) {
        Optional damageTypeResourceKeyOptional = source.m_269150_().m_203543_();
        if (damageTypeResourceKeyOptional.isEmpty()) {
            FirstAid.LOGGER.warn("Attempted to get damage distrbution for unregistered damage source!");
            return null;
        }
        ResourceKey damageTypeResourceKey = (ResourceKey)damageTypeResourceKeyOptional.get();
        IDamageDistribution distribution = this.distributionsStatic.get(damageTypeResourceKey);
        if (distribution == null) {
            for (Pair<Predicate<DamageSource>, IDamageDistribution> pair : this.distributionsDynamic) {
                if (!((Predicate)pair.getLeft()).test(source)) continue;
                distribution = (IDamageDistribution)pair.getRight();
                break;
            }
        }
        return distribution;
    }

    @Override
    @Nonnull
    public IDebuff[] getDebuffs(@Nonnull EnumDebuffSlot slot) {
        return (IDebuff[])this.debuffs.get((Object)slot).stream().map(Supplier::get).toArray(IDebuff[]::new);
    }
}

