/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.apiimpl;

import com.google.common.primitives.Floats;
import com.google.common.primitives.Ints;
import cpw.mods.modlauncher.TransformingClassLoader;
import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.debuff.DebuffBuilderFactory;
import ichttt.mods.firstaid.api.debuff.IDebuffBuilder;
import ichttt.mods.firstaid.api.distribution.DamageDistributionBuilderFactory;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.api.event.RegisterDamageDistributionEvent;
import ichttt.mods.firstaid.api.event.RegisterDebuffEvent;
import ichttt.mods.firstaid.api.event.RegisterHealingTypeEvent;
import ichttt.mods.firstaid.common.RegistryObjects;
import ichttt.mods.firstaid.common.apiimpl.DebuffBuilderFactoryImpl;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.apiimpl.distribution.DamageDistributionBuilderFactoryImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.ArrayUtils;

public class RegistryManager {
    public static final List<String> debuffConfigErrors = new ArrayList<String>();

    public static void registerAndValidate() {
        MinecraftForge.EVENT_BUS.register(RegistryManager.class);
        if (RegistryManager.class.getClassLoader() != FirstAidRegistry.class.getClassLoader()) {
            FirstAid.LOGGER.error("API and normal mod loaded on two different classloaders! Normal mod: {}, First Aid Registry: {}", (Object)RegistryManager.class.getName(), (Object)FirstAidRegistry.class.getName());
            throw new RuntimeException("API and normal mod loaded on two different classloaders!");
        }
        TransformingClassLoader tcl = (TransformingClassLoader)RegistryManager.class.getClassLoader();
        if (tcl.getLoadedClass(RegistryManager.class.getName()) != RegistryManager.class) {
            FirstAid.LOGGER.error("API is not the same as under tcl loaded classes! In TCL cache: {}, actual: {}", (Object)tcl.getLoadedClass(RegistryManager.class.getName()), RegistryManager.class);
            throw new RuntimeException("API is not under loaded classes in the TCL!");
        }
    }

    public static void fireRegistryEvents(Level level) {
        if (FirstAidRegistry.getImpl() != null) {
            FirstAid.LOGGER.warn("A registry has already been set!");
        }
        RegisterDamageDistributionEvent registerDamageDistributionEvent = new RegisterDamageDistributionEvent(level, new DamageDistributionBuilderFactoryImpl());
        MinecraftForge.EVENT_BUS.post((Event)registerDamageDistributionEvent);
        RegisterDebuffEvent registerDebuffEvent = new RegisterDebuffEvent(level, new DebuffBuilderFactoryImpl());
        MinecraftForge.EVENT_BUS.post((Event)registerDebuffEvent);
        RegisterHealingTypeEvent registerHealingTypeEvent = new RegisterHealingTypeEvent(level);
        MinecraftForge.EVENT_BUS.post((Event)registerHealingTypeEvent);
        FirstAidRegistryImpl impl = new FirstAidRegistryImpl(registerDamageDistributionEvent.getDistributionsDynamic(), registerDamageDistributionEvent.getDistributionsStatic(), registerHealingTypeEvent.getHealerMap(), registerDebuffEvent.getDebuffs());
        FirstAidRegistry.setImpl(impl);
    }

    public static void destroyRegistry() {
        if (FirstAidRegistry.getImpl() == null) {
            FirstAid.LOGGER.warn("No registry has been set!");
        }
        FirstAidRegistry.setImpl(null);
    }

    @SubscribeEvent
    public static void registerDamageDistributions(RegisterDamageDistributionEvent event) {
        Level level = event.getLevel();
        DamageDistributionBuilderFactory distributionBuilderFactory = event.getDistributionBuilderFactory();
        DamageSources damageSources = level.m_269111_();
        event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.FEET, EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT).addDistributionLayer(EquipmentSlot.LEGS, EnumPlayerPart.LEFT_LEG, EnumPlayerPart.RIGHT_LEG).build(), damageSources.m_268989_(), damageSources.m_269047_());
        event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.HEAD, EnumPlayerPart.HEAD).addDistributionLayer(EquipmentSlot.CHEST, EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM).ignoreOrder().build(), damageSources.m_269548_());
        event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.FEET, EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT).build(), damageSources.m_269571_());
        event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.LEGS, EnumPlayerPart.RIGHT_LEG, EnumPlayerPart.LEFT_LEG).addDistributionLayer(EquipmentSlot.FEET, EnumPlayerPart.LEFT_FOOT, EnumPlayerPart.RIGHT_FOOT).addDistributionLayer(EquipmentSlot.CHEST, EnumPlayerPart.LEFT_ARM, EnumPlayerPart.RIGHT_ARM, EnumPlayerPart.BODY).build(), damageSources.m_269555_());
        event.registerDamageDistributionStatic(distributionBuilderFactory.newRandomBuilder().build(), damageSources.m_269425_());
        if (((Boolean)FirstAidConfig.GENERAL.hardMode.get()).booleanValue()) {
            event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.CHEST, EnumPlayerPart.BODY).disableNeighbourRestDistribution().build(), damageSources.m_269064_());
            event.registerDamageDistributionStatic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.CHEST, EnumPlayerPart.BODY).addDistributionLayer(EquipmentSlot.HEAD, EnumPlayerPart.HEAD).ignoreOrder().disableNeighbourRestDistribution().build(), damageSources.m_269063_());
        } else {
            event.registerDamageDistributionStatic(distributionBuilderFactory.newRandomBuilder().tryNoKill().build(), damageSources.m_269064_(), damageSources.m_269063_());
        }
        event.registerDamageDistributionStatic(distributionBuilderFactory.newRandomBuilder().tryNoKill().build(), damageSources.m_269318_(), damageSources.m_269354_());
        event.registerDamageDistributionDynamic(distributionBuilderFactory.newEqualBuilder().reductionMultiplier(0.8f).build(), damageSource -> damageSource.m_269533_(DamageTypeTags.f_268415_));
        event.registerDamageDistributionDynamic(distributionBuilderFactory.newStandardBuilder().addDistributionLayer(EquipmentSlot.HEAD, EnumPlayerPart.HEAD).build(), damageSource -> damageSource.m_269150_().m_203565_(DamageTypes.f_268526_));
    }

    @SubscribeEvent
    public static void registerDebuffs(RegisterDebuffEvent event) {
        RegistryManager.loadValuesFromConfig(event, "blindness", RegistryObjects.HEARTBEAT, FirstAidConfig.GENERAL.head.blindnessConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(event, "nausea", null, FirstAidConfig.GENERAL.head.nauseaConditions, EnumDebuffSlot.HEAD);
        RegistryManager.loadValuesFromConfig(event, "nausea", null, FirstAidConfig.GENERAL.body.nauseaConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(event, "weakness", FirstAidConfig.GENERAL.body.weaknessConditions, EnumDebuffSlot.BODY);
        RegistryManager.loadValuesFromConfig(event, "mining_fatigue", FirstAidConfig.GENERAL.arms.miningFatigueConditions, EnumDebuffSlot.ARMS);
        RegistryManager.loadValuesFromConfig(event, "slowness", FirstAidConfig.GENERAL.legsAndFeet.slownessConditions, EnumDebuffSlot.LEGS_AND_FEET);
    }

    private static void loadValuesFromConfig(RegisterDebuffEvent event, String potionName, Supplier<SoundEvent> soundEventSupplier, FirstAidConfig.General.ConditionOnHit config, EnumDebuffSlot slot) {
        DebuffBuilderFactory debuffBuilderFactory = event.getDebuffBuilderFactory();
        float[] damageTaken = Floats.toArray((Collection)((Collection)config.damageTaken.get()));
        int[] debuffLength = Ints.toArray((Collection)((Collection)config.debuffLength.get()));
        if (debuffLength.length != damageTaken.length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (debuffLength.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        float[] healthPercentageLeft = new float[damageTaken.length];
        System.arraycopy(damageTaken, 0, healthPercentageLeft, 0, damageTaken.length);
        Arrays.sort(healthPercentageLeft);
        ArrayUtils.reverse((float[])healthPercentageLeft);
        if (!Arrays.equals(healthPercentageLeft, damageTaken)) {
            RegistryManager.logError("The damageTaken field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = debuffBuilderFactory.newOnHitDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < damageTaken.length; ++i) {
            builder.addBound(damageTaken[i], debuffLength[i]);
        }
        if (soundEventSupplier != null) {
            builder.addSoundEffect(soundEventSupplier);
        }
        event.registerDebuff(builder.build(), slot);
    }

    private static void loadValuesFromConfig(RegisterDebuffEvent event, String potionName, FirstAidConfig.General.ConditionConstant config, EnumDebuffSlot slot) {
        float[] healthPercentageLeft;
        DebuffBuilderFactory debuffBuilderFactory = event.getDebuffBuilderFactory();
        int[] debuffStrength = Ints.toArray((Collection)((Collection)config.debuffStrength.get()));
        if (debuffStrength.length != (healthPercentageLeft = Floats.toArray((Collection)((Collection)config.healthPercentageLeft.get()))).length) {
            RegistryManager.logError("The fields to not have the same amount of values!", potionName, slot);
            return;
        }
        if (healthPercentageLeft.length == 0) {
            RegistryManager.logError("The fields are empty!", potionName, slot);
            return;
        }
        if (!ArrayUtils.isSorted((float[])healthPercentageLeft)) {
            RegistryManager.logError("The healthPercentageLeft field is not sorted right!", potionName, slot);
            return;
        }
        IDebuffBuilder builder = debuffBuilderFactory.newConstantDebuffBuilder(potionName);
        builder.addEnableCondition(() -> ((ForgeConfigSpec.BooleanValue)config.enabled).get());
        for (int i = 0; i < healthPercentageLeft.length; ++i) {
            builder.addBound(healthPercentageLeft[i], debuffStrength[i]);
        }
        event.registerDebuff(builder.build(), slot);
    }

    private static void logError(String error, String potionName, EnumDebuffSlot slot) {
        String errorMsg = String.format("Invalid config entry for debuff %s at part %s: %s", potionName, slot.toString(), error);
        FirstAid.LOGGER.warn(errorMsg);
        debuffConfigErrors.add(errorMsg);
    }
}

