/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPartHealer;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class DamageablePart
extends AbstractDamageablePart {
    private int maxHealth;
    @Nonnull
    private final IDebuff[] debuffs;
    private float absorption;

    public DamageablePart(int maxHealth, boolean canCauseDeath, @Nonnull EnumPlayerPart playerPart, IDebuff ... debuffs) {
        super(maxHealth, canCauseDeath, playerPart);
        this.maxHealth = maxHealth;
        this.currentHealth = maxHealth;
        this.debuffs = debuffs;
    }

    @Override
    public float heal(float amount, @Nullable Player player, boolean applyDebuff) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        float notFitting = Math.abs(Math.min(0.0f, (float)this.maxHealth - (this.currentHealth + amount)));
        this.currentHealth = Math.min((float)this.maxHealth, this.currentHealth + amount);
        if (notFitting > 0.0f) {
            float oldHealth = this.currentHealth;
            this.currentHealth = Math.min(this.currentHealth + notFitting, this.currentHealth);
            notFitting -= this.currentHealth - oldHealth;
        }
        float finalNotFitting = notFitting;
        if (applyDebuff) {
            Objects.requireNonNull(player, "Got null player with applyDebuff = true");
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleHealing(amount - finalNotFitting, this.currentHealth / (float)this.maxHealth, (ServerPlayer)player));
        }
        return notFitting;
    }

    @Override
    public float damage(float amount, @Nullable Player player, boolean applyDebuff) {
        return this.damage(amount, player, applyDebuff, 0.0f);
    }

    @Override
    public float damage(float amount, @Nullable Player player, boolean applyDebuff, float minHealth) {
        if (amount <= 0.0f) {
            return 0.0f;
        }
        if (minHealth > (float)this.maxHealth) {
            throw new IllegalArgumentException("Cannot damage part with minHealth " + minHealth + " while he has more max health (" + this.maxHealth + ")");
        }
        float origAmount = amount;
        if (this.absorption > 0.0f) {
            amount = Math.abs(Math.min(0.0f, this.absorption - origAmount));
            this.absorption = Math.max(0.0f, this.absorption - origAmount);
        }
        float notFitting = Math.abs(Math.min(minHealth, this.currentHealth - amount) - minHealth);
        this.currentHealth = Math.max(minHealth, this.currentHealth - amount);
        if (applyDebuff) {
            Objects.requireNonNull(player, "Got null player with applyDebuff = true");
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleDamageTaken(origAmount - notFitting, this.currentHealth / (float)this.maxHealth, (ServerPlayer)player));
        }
        return notFitting;
    }

    @Override
    public void tick(Level world, Player player, boolean tickDebuffs) {
        if (this.activeHealer != null) {
            if (this.activeHealer.tick()) {
                this.heal(1.0f, player, !world.f_46443_);
            }
            if (this.activeHealer.hasFinished()) {
                this.activeHealer = null;
            }
        }
        if (!world.f_46443_ && tickDebuffs) {
            Arrays.stream(this.debuffs).forEach(debuff -> debuff.update(player, this.currentHealth / (float)this.maxHealth));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128350_("health", this.currentHealth);
        if (((Boolean)FirstAidConfig.SERVER.scaleMaxHealth.get()).booleanValue()) {
            compound.m_128405_("maxHealth", this.maxHealth);
        }
        if (this.absorption > 0.0f) {
            compound.m_128350_("absorption", this.absorption);
        }
        if (this.activeHealer != null) {
            compound.m_128365_("healer", (Tag)this.activeHealer.stack.serializeNBT());
            compound.m_128405_("itemTicks", this.activeHealer.getTicksPassed());
            compound.m_128405_("itemHeals", this.activeHealer.getHealsDone());
        }
        return compound;
    }

    public void deserializeNBT(@Nullable CompoundTag nbt) {
        if (nbt == null) {
            return;
        }
        if (nbt.m_128441_("maxHealth") && ((Boolean)FirstAidConfig.SERVER.scaleMaxHealth.get()).booleanValue()) {
            this.maxHealth = nbt.m_128451_("maxHealth");
        }
        this.currentHealth = Math.min((float)this.maxHealth, nbt.m_128457_("health"));
        ItemStack stack = null;
        if (nbt.m_128441_("healer")) {
            stack = ItemStack.m_41712_((CompoundTag)((CompoundTag)Objects.requireNonNull(nbt.m_128423_("healer"))));
        }
        if (stack != null) {
            AbstractPartHealer healer = FirstAidRegistryImpl.getImplOrThrow().getPartHealer(stack);
            if (healer == null) {
                FirstAid.LOGGER.warn("Failed to lookup healer for item {}", (Object)stack.m_41720_());
            } else {
                this.activeHealer = healer.loadNBT(nbt.m_128451_("itemTicks"), nbt.m_128451_("itemHeals"));
            }
        }
        if (nbt.m_128441_("absorption")) {
            this.absorption = nbt.m_128457_("absorption");
        }
        Arrays.stream(this.debuffs).forEach(debuff -> debuff.handleHealing(0.0f, this.currentHealth / (float)this.maxHealth, null));
    }

    @Override
    public void setAbsorption(float absorption) {
        if (absorption > 4.0f && ((Boolean)FirstAidConfig.SERVER.capMaxHealth.get()).booleanValue()) {
            absorption = 4.0f;
        }
        if (absorption > 32.0f) {
            absorption = 32.0f;
        }
        this.absorption = absorption;
        this.currentHealth = Math.min((float)this.maxHealth + absorption, this.currentHealth);
    }

    @Override
    public float getAbsorption() {
        return this.absorption;
    }

    @Override
    public void setMaxHealth(int maxHealth) {
        if (maxHealth > 12 && ((Boolean)FirstAidConfig.SERVER.capMaxHealth.get()).booleanValue()) {
            maxHealth = 12;
        }
        if (maxHealth > 128) {
            maxHealth = 128;
        }
        this.maxHealth = Math.max(2, maxHealth);
        this.currentHealth = Math.min(this.currentHealth, (float)this.maxHealth);
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }
}

