/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.FirstAidConfig;
import ichttt.mods.firstaid.api.FirstAidRegistry;
import ichttt.mods.firstaid.api.damagesystem.AbstractDamageablePart;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.debuff.IDebuff;
import ichttt.mods.firstaid.api.enums.EnumDebuffSlot;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.client.util.HealthRenderUtils;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.EventHandler;
import ichttt.mods.firstaid.common.RegistryObjects;
import ichttt.mods.firstaid.common.SynchedEntityDataWrapper;
import ichttt.mods.firstaid.common.apiimpl.FirstAidRegistryImpl;
import ichttt.mods.firstaid.common.compat.playerrevive.PRCompatManager;
import ichttt.mods.firstaid.common.damagesystem.DamageablePart;
import ichttt.mods.firstaid.common.damagesystem.debuff.SharedDebuff;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

public class PlayerDamageModel
extends AbstractPlayerDamageModel {
    private final Set<SharedDebuff> sharedDebuffs = new HashSet<SharedDebuff>();
    private int morphineTicksLeft = 0;
    private int sleepBlockTicks = 0;
    private float prevHealthCurrent = -1.0f;
    private float prevScaleFactor;
    private final boolean noCritical;
    private boolean needsMorphineUpdate = false;
    private int resyncTimer = -1;

    public static PlayerDamageModel create() {
        FirstAidRegistry registry = FirstAidRegistryImpl.getImplOrThrow();
        IDebuff[] headDebuffs = registry.getDebuffs(EnumDebuffSlot.HEAD);
        IDebuff[] bodyDebuffs = registry.getDebuffs(EnumDebuffSlot.BODY);
        IDebuff[] armsDebuffs = registry.getDebuffs(EnumDebuffSlot.ARMS);
        IDebuff[] legFootDebuffs = registry.getDebuffs(EnumDebuffSlot.LEGS_AND_FEET);
        return new PlayerDamageModel(headDebuffs, bodyDebuffs, armsDebuffs, legFootDebuffs);
    }

    protected PlayerDamageModel(IDebuff[] headDebuffs, IDebuff[] bodyDebuffs, IDebuff[] armDebuffs, IDebuff[] legFootDebuffs) {
        super(new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthHead.get(), (Boolean)FirstAidConfig.SERVER.causeDeathHead.get(), EnumPlayerPart.HEAD, headDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftArm.get(), false, EnumPlayerPart.LEFT_ARM, armDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftLeg.get(), false, EnumPlayerPart.LEFT_LEG, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthLeftFoot.get(), false, EnumPlayerPart.LEFT_FOOT, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthBody.get(), (Boolean)FirstAidConfig.SERVER.causeDeathBody.get(), EnumPlayerPart.BODY, bodyDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightArm.get(), false, EnumPlayerPart.RIGHT_ARM, armDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightLeg.get(), false, EnumPlayerPart.RIGHT_LEG, legFootDebuffs), new DamageablePart((Integer)FirstAidConfig.SERVER.maxHealthRightFoot.get(), false, EnumPlayerPart.RIGHT_FOOT, legFootDebuffs));
        for (IDebuff debuff : armDebuffs) {
            this.sharedDebuffs.add((SharedDebuff)debuff);
        }
        for (IDebuff debuff : legFootDebuffs) {
            this.sharedDebuffs.add((SharedDebuff)debuff);
        }
        this.noCritical = (Boolean)FirstAidConfig.SERVER.causeDeathBody.get() == false && (Boolean)FirstAidConfig.SERVER.causeDeathHead.get() == false;
    }

    public CompoundTag serializeNBT() {
        CompoundTag tagCompound = new CompoundTag();
        tagCompound.m_128365_("head", this.HEAD.serializeNBT());
        tagCompound.m_128365_("leftArm", this.LEFT_ARM.serializeNBT());
        tagCompound.m_128365_("leftLeg", this.LEFT_LEG.serializeNBT());
        tagCompound.m_128365_("leftFoot", this.LEFT_FOOT.serializeNBT());
        tagCompound.m_128365_("body", this.BODY.serializeNBT());
        tagCompound.m_128365_("rightArm", this.RIGHT_ARM.serializeNBT());
        tagCompound.m_128365_("rightLeg", this.RIGHT_LEG.serializeNBT());
        tagCompound.m_128365_("rightFoot", this.RIGHT_FOOT.serializeNBT());
        tagCompound.m_128379_("hasTutorial", this.hasTutorial);
        return tagCompound;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.HEAD.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("head")));
        this.LEFT_ARM.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("leftArm")));
        this.LEFT_LEG.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("leftLeg")));
        this.LEFT_FOOT.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("leftFoot")));
        this.BODY.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("body")));
        this.RIGHT_ARM.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("rightArm")));
        this.RIGHT_LEG.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("rightLeg")));
        this.RIGHT_FOOT.deserializeNBT((Tag)((CompoundTag)nbt.m_128423_("rightFoot")));
        if (nbt.m_128441_("morphineTicks")) {
            this.morphineTicksLeft = nbt.m_128451_("morphineTicks");
            this.needsMorphineUpdate = true;
        }
        if (nbt.m_128441_("hasTutorial")) {
            this.hasTutorial = nbt.m_128471_("hasTutorial");
        }
    }

    @Override
    public void tick(Level world, Player player) {
        if (this.isDead(player)) {
            return;
        }
        world.m_46473_().m_6180_("FirstAidPlayerModel");
        if (this.sleepBlockTicks > 0) {
            --this.sleepBlockTicks;
        } else if (this.sleepBlockTicks < 0) {
            throw new RuntimeException("Negative sleepBlockTicks " + this.sleepBlockTicks);
        }
        float newCurrentHealth = this.calculateNewCurrentHealth(player);
        if (Float.isNaN(newCurrentHealth)) {
            FirstAid.LOGGER.warn("New current health is not a number, setting it to 0!");
            newCurrentHealth = 0.0f;
        }
        if (newCurrentHealth <= 0.0f) {
            FirstAid.LOGGER.error("Got {} health left, but isn't marked as dead!", (Object)Float.valueOf(newCurrentHealth));
            world.m_46473_().m_7238_();
            return;
        }
        if (!world.f_46443_ && this.resyncTimer != -1) {
            --this.resyncTimer;
            if (this.resyncTimer == 0) {
                this.resyncTimer = -1;
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(this, true));
            }
        }
        if (Float.isInfinite(newCurrentHealth)) {
            FirstAid.LOGGER.error("Error calculating current health: Value was infinite");
        } else {
            if (newCurrentHealth != this.prevHealthCurrent) {
                ((SynchedEntityDataWrapper)player.f_19804_).set_impl(Player.f_20961_, Float.valueOf(newCurrentHealth));
            }
            this.prevHealthCurrent = newCurrentHealth;
        }
        if (!this.hasTutorial) {
            this.hasTutorial = CapProvider.tutorialDone.contains(player.m_7755_().getString());
        }
        this.runScaleLogic(player);
        MobEffect morphineEffect = (MobEffect)RegistryObjects.MORPHINE_EFFECT.get();
        if (this.needsMorphineUpdate) {
            player.m_7292_(new MobEffectInstance(morphineEffect, this.morphineTicksLeft, 0, false, false));
        }
        MobEffectInstance morphine = player.m_21124_(morphineEffect);
        if (!this.needsMorphineUpdate) {
            this.morphineTicksLeft = morphine == null ? 0 : morphine.m_19557_();
        }
        this.needsMorphineUpdate = false;
        world.m_46473_().m_6180_("PartDebuffs");
        this.forEach(part -> part.tick(world, player, morphine == null));
        if (morphine == null && !world.f_46443_) {
            this.sharedDebuffs.forEach(sharedDebuff -> sharedDebuff.tick(player));
        }
        world.m_46473_().m_7238_();
        world.m_46473_().m_7238_();
    }

    public static int getRandMorphineDuration() {
        return EventHandler.RAND.nextInt(5) * 20 * 15 + 4200;
    }

    @Override
    @Deprecated
    public void applyMorphine() {
        this.morphineTicksLeft = PlayerDamageModel.getRandMorphineDuration();
        this.needsMorphineUpdate = true;
    }

    @Override
    public void applyMorphine(Player player) {
        player.m_7292_(new MobEffectInstance((MobEffect)RegistryObjects.MORPHINE_EFFECT.get(), PlayerDamageModel.getRandMorphineDuration(), 0, false, false));
    }

    @Override
    @Deprecated
    public int getMorphineTicks() {
        return this.morphineTicksLeft;
    }

    @Override
    @Nonnull
    public Iterator<AbstractDamageablePart> iterator() {
        return new Iterator<AbstractDamageablePart>(){
            private byte count = 0;

            @Override
            public boolean hasNext() {
                return this.count < 8;
            }

            @Override
            public AbstractDamageablePart next() {
                if (this.count >= 8) {
                    throw new NoSuchElementException();
                }
                AbstractDamageablePart part = PlayerDamageModel.this.getFromEnum(EnumPlayerPart.VALUES[this.count]);
                this.count = (byte)(this.count + 1);
                return part;
            }
        };
    }

    private float calculateNewCurrentHealth(Player player) {
        float currentHealth = 0.0f;
        FirstAidConfig.Server.VanillaHealthCalculationMode mode = (FirstAidConfig.Server.VanillaHealthCalculationMode)((Object)FirstAidConfig.SERVER.vanillaHealthCalculation.get());
        if (this.noCritical) {
            mode = FirstAidConfig.Server.VanillaHealthCalculationMode.AVERAGE_ALL;
        }
        switch (mode) {
            case AVERAGE_CRITICAL: {
                int maxHealth = 0;
                for (AbstractDamageablePart part : this) {
                    if (!part.canCauseDeath) continue;
                    currentHealth += part.currentHealth;
                    maxHealth += part.getMaxHealth();
                }
                currentHealth /= (float)maxHealth;
                break;
            }
            case MIN_CRITICAL: {
                AbstractDamageablePart minimal = null;
                float lowest = Float.MAX_VALUE;
                for (AbstractDamageablePart part : this) {
                    float partCurrentHealth;
                    if (!part.canCauseDeath || !((partCurrentHealth = part.currentHealth) < lowest)) continue;
                    minimal = part;
                    lowest = partCurrentHealth;
                }
                Objects.requireNonNull(minimal);
                currentHealth = minimal.currentHealth / (float)minimal.getMaxHealth();
                break;
            }
            case AVERAGE_ALL: {
                for (AbstractDamageablePart part : this) {
                    currentHealth += part.currentHealth;
                }
                currentHealth /= (float)this.getCurrentMaxHealth();
                break;
            }
            case CRITICAL_50_PERCENT_OTHER_50_PERCENT: {
                float currentNormal = 0.0f;
                int maxNormal = 0;
                float currentCritical = 0.0f;
                int maxCritical = 0;
                for (AbstractDamageablePart part : this) {
                    if (!part.canCauseDeath) {
                        currentNormal += part.currentHealth;
                        maxNormal += part.getMaxHealth();
                        continue;
                    }
                    currentCritical += part.currentHealth;
                    maxCritical += part.getMaxHealth();
                }
                float avgNormal = currentNormal / (float)maxNormal;
                float avgCritical = currentCritical / (float)maxCritical;
                currentHealth = (avgCritical + avgNormal) / 2.0f;
                break;
            }
            default: {
                throw new RuntimeException("Unknown constant " + mode);
            }
        }
        return currentHealth * player.m_21233_();
    }

    @Override
    public boolean isDead(@Nullable Player player) {
        boolean bleeding = PRCompatManager.getHandler().isBleeding(player);
        if (bleeding) {
            return true;
        }
        if (player != null && !player.m_6084_()) {
            return true;
        }
        if (this.noCritical) {
            boolean dead = true;
            for (AbstractDamageablePart part : this) {
                if (!(part.currentHealth > 0.0f)) continue;
                dead = false;
                break;
            }
            return dead;
        }
        for (AbstractDamageablePart part : this) {
            if (!part.canCauseDeath || !(part.currentHealth <= 0.0f)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Float getAbsorption() {
        float value = 0.0f;
        for (AbstractDamageablePart part : this) {
            value += part.getAbsorption();
        }
        return Float.valueOf(value);
    }

    @Override
    public void setAbsorption(float absorption) {
        float newAbsorption = absorption / 8.0f;
        this.forEach(damageablePart -> damageablePart.setAbsorption(newAbsorption));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public int getMaxRenderSize() {
        int max = 0;
        for (AbstractDamageablePart part : this) {
            int newMax = FirstAidConfig.CLIENT.overlayMode.get() == FirstAidConfig.Client.OverlayMode.NUMBERS ? Minecraft.m_91087_().f_91062_.m_92895_(HealthRenderUtils.TEXT_FORMAT.format(part.currentHealth) + "/" + part.getMaxHealth()) + 1 : (int)((float)((int)((float)part.getMaxHealth() + part.getAbsorption() + 0.9999f) + 1) / 2.0f * 9.0f);
            max = Math.max(max, newMax);
        }
        return max;
    }

    @Override
    public void sleepHeal(Player player) {
        if (this.sleepBlockTicks > 0) {
            return;
        }
        CommonUtils.healPlayerByPercentage((Double)FirstAidConfig.SERVER.sleepHealPercentage.get(), this, player);
        this.sleepBlockTicks = 20;
    }

    @Override
    public int getCurrentMaxHealth() {
        int maxHealth = 0;
        for (AbstractDamageablePart part : this) {
            maxHealth += part.getMaxHealth();
        }
        return maxHealth;
    }

    @Override
    public void revivePlayer(Player player) {
        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
            CommonUtils.debugLogStacktrace("Reviving player");
        }
        player.revive();
        for (AbstractDamageablePart part : this) {
            if (!part.canCauseDeath && !this.noCritical || !(part.currentHealth <= 0.0f)) continue;
            part.currentHealth = 1.0f;
        }
        if (!player.f_19853_.f_46443_ && player instanceof ServerPlayer) {
            FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)new MessageSyncDamageModel(this, true));
        }
    }

    @Override
    public void runScaleLogic(Player player) {
        if (((Boolean)FirstAidConfig.SERVER.scaleMaxHealth.get()).booleanValue()) {
            player.f_19853_.m_46473_().m_6180_("healthscaling");
            float globalFactor = player.m_21233_() / 20.0f;
            if (this.prevScaleFactor != globalFactor) {
                if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                    FirstAid.LOGGER.info("Starting health scaling factor {} -> {} (max health {})", (Object)Float.valueOf(this.prevScaleFactor), (Object)Float.valueOf(globalFactor), (Object)Float.valueOf(player.m_21233_()));
                }
                player.f_19853_.m_46473_().m_6180_("distribution");
                int reduced = 0;
                int added = 0;
                float expectedNewMaxHealth = 0.0f;
                int newMaxHealth = 0;
                for (AbstractDamageablePart part : this) {
                    float floatResult = (float)part.initialMaxHealth * globalFactor;
                    expectedNewMaxHealth += floatResult;
                    int result = (int)floatResult;
                    if (result % 2 == 1) {
                        int partMaxHealth = part.getMaxHealth();
                        if (part.currentHealth < (float)partMaxHealth && reduced < 4) {
                            --result;
                            ++reduced;
                        } else if (part.currentHealth > (float)partMaxHealth && added < 4) {
                            ++result;
                            ++added;
                        } else if (reduced > added) {
                            ++result;
                            ++added;
                        } else {
                            --result;
                            ++reduced;
                        }
                    }
                    newMaxHealth += result;
                    if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                        FirstAid.LOGGER.info("Part {} max health: {} initial; {} old; {} new", (Object)part.part.name(), (Object)part.initialMaxHealth, (Object)part.getMaxHealth(), (Object)result);
                    }
                    part.setMaxHealth(result);
                }
                player.f_19853_.m_46473_().m_6182_("correcting");
                if (Math.abs(expectedNewMaxHealth - (float)newMaxHealth) >= 2.0f) {
                    if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                        FirstAid.LOGGER.info("Entering second stage - diff {}", (Object)Float.valueOf(Math.abs(expectedNewMaxHealth - (float)newMaxHealth)));
                    }
                    ArrayList<AbstractDamageablePart> prioList = new ArrayList<AbstractDamageablePart>();
                    for (AbstractDamageablePart part : this) {
                        prioList.add(part);
                    }
                    prioList.sort(Comparator.comparingInt(AbstractDamageablePart::getMaxHealth));
                    for (AbstractDamageablePart part : prioList) {
                        int maxHealth = part.getMaxHealth();
                        if (((Boolean)FirstAidConfig.GENERAL.debug.get()).booleanValue()) {
                            FirstAid.LOGGER.info("Part {}: Second stage with total diff {}", (Object)part.part.name(), (Object)Float.valueOf(Math.abs(expectedNewMaxHealth - (float)newMaxHealth)));
                        }
                        if (expectedNewMaxHealth > (float)newMaxHealth) {
                            part.setMaxHealth(maxHealth + 2);
                            newMaxHealth += part.getMaxHealth() - maxHealth;
                        } else if (expectedNewMaxHealth < (float)newMaxHealth) {
                            part.setMaxHealth(maxHealth - 2);
                            newMaxHealth -= maxHealth - part.getMaxHealth();
                        }
                        if (!(Math.abs(expectedNewMaxHealth - (float)newMaxHealth) < 2.0f)) continue;
                        break;
                    }
                }
                player.f_19853_.m_46473_().m_7238_();
            }
            this.prevScaleFactor = globalFactor;
            player.f_19853_.m_46473_().m_7238_();
        }
    }

    @Override
    public void scheduleResync() {
        if (this.resyncTimer == -1) {
            this.resyncTimer = 3;
        } else {
            FirstAid.LOGGER.warn("resync already scheduled!");
        }
    }

    @Override
    public boolean hasNoCritical() {
        return this.noCritical;
    }
}

