/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.damagesystem.debuff;

import ichttt.mods.firstaid.common.damagesystem.debuff.AbstractDebuff;
import it.unimi.dsi.fastutil.floats.Float2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.floats.Float2IntMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;

public class ConstantDebuff
extends AbstractDebuff {
    private int ticks = 0;
    private int activeMultiplier = 0;

    public ConstantDebuff(@Nonnull String potionName, @Nonnull Float2IntLinkedOpenHashMap map, @Nonnull BooleanSupplier isEnabled) {
        super(potionName, map, isEnabled);
    }

    private void syncMultiplier(float healthPerMax) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        boolean found = false;
        for (Float2IntMap.Entry entry : this.map.float2IntEntrySet()) {
            if (!(healthPerMax < entry.getFloatKey())) continue;
            this.ticks = 0;
            this.activeMultiplier = entry.getIntValue();
            found = true;
            break;
        }
        if (!found) {
            this.activeMultiplier = 0;
        }
    }

    @Override
    public void handleDamageTaken(float damage, float healthPerMax, ServerPlayer player) {
        this.syncMultiplier(healthPerMax);
    }

    @Override
    public void handleHealing(float healingDone, float healthPerMax, ServerPlayer player) {
        this.syncMultiplier(healthPerMax);
    }

    @Override
    public void update(Player player) {
        this.update(player, -1.0f);
    }

    @Override
    public void update(Player player, float healthPerMax) {
        if (!this.isEnabled.getAsBoolean()) {
            return;
        }
        if (this.activeMultiplier == 0) {
            this.ticks = 0;
        } else {
            if (this.ticks == 0) {
                if (healthPerMax != -1.0f) {
                    this.syncMultiplier(healthPerMax);
                }
                if (this.activeMultiplier != 0) {
                    player.m_7292_(new MobEffectInstance(this.effect, 169, this.activeMultiplier - 1, false, false));
                }
            }
            ++this.ticks;
            if (this.ticks >= 79) {
                this.ticks = 0;
            }
        }
    }
}

