/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.api.damagesystem.AbstractPlayerDamageModel;
import ichttt.mods.firstaid.api.enums.EnumPlayerPart;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.NetworkEvent;

public class MessageAddHealth {
    private final float[] table;

    public MessageAddHealth(FriendlyByteBuf buffer) {
        this.table = new float[8];
        for (int i = 0; i < 8; ++i) {
            this.table[i] = buffer.readFloat();
        }
    }

    public MessageAddHealth(float[] table) {
        this.table = table;
    }

    public void encode(FriendlyByteBuf buf) {
        for (float f : this.table) {
            buf.writeFloat(f);
        }
    }

    public static class Handler {
        public static void onMessage(MessageAddHealth message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            CommonUtils.checkClient(ctx);
            ctx.enqueueWork(() -> {
                LocalPlayer playerSP = Minecraft.m_91087_().f_91074_;
                LazyOptional<AbstractPlayerDamageModel> optDamageModel = CommonUtils.getOptionalDamageModel((Player)playerSP);
                if (optDamageModel.isPresent()) {
                    AbstractPlayerDamageModel damageModel = (AbstractPlayerDamageModel)optDamageModel.resolve().get();
                    for (int i = 0; i < message.table.length; ++i) {
                        float f = message.table[i];
                        EnumPlayerPart part = EnumPlayerPart.VALUES[i];
                        damageModel.getFromEnum(part).heal(f, (Player)playerSP, false);
                    }
                } else {
                    FirstAid.LOGGER.debug("Failed to find damage model, what?");
                }
            });
        }
    }
}

