/*
 * Decompiled with CFR 0.152.
 */
package ichttt.mods.firstaid.common.network;

import ichttt.mods.firstaid.FirstAid;
import ichttt.mods.firstaid.common.CapProvider;
import ichttt.mods.firstaid.common.network.MessageSyncDamageModel;
import ichttt.mods.firstaid.common.util.CommonUtils;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class MessageClientRequest {
    private final Type type;

    public MessageClientRequest(FriendlyByteBuf buffer) {
        this.type = Type.TYPES[buffer.readByte()];
    }

    public MessageClientRequest(Type type) {
        this.type = type;
    }

    public void encode(FriendlyByteBuf buf) {
        buf.writeByte(this.type.ordinal());
    }

    public static enum Type {
        TUTORIAL_COMPLETE,
        REQUEST_REFRESH;

        private static final Type[] TYPES;

        static {
            TYPES = Type.values();
        }
    }

    public static class Handler {
        public static void onMessage(MessageClientRequest message, Supplier<NetworkEvent.Context> supplier) {
            NetworkEvent.Context ctx = supplier.get();
            ServerPlayer player = CommonUtils.checkServer(ctx);
            if (message.type == Type.TUTORIAL_COMPLETE) {
                CapProvider.tutorialDone.add(player.m_7755_().getString());
                ctx.enqueueWork(() -> {
                    CommonUtils.getDamageModel((Player)player).hasTutorial = true;
                });
            } else if (message.type == Type.REQUEST_REFRESH) {
                FirstAid.NETWORKING.send(PacketDistributor.PLAYER.with(() -> player), (Object)new MessageSyncDamageModel(CommonUtils.getDamageModel((Player)player), true));
            }
        }
    }
}

