/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data;

import com.rollbar.api.json.JsonSerializable;
import java.util.HashMap;
import java.util.Map;

public class Server
implements JsonSerializable {
    private final String host;
    private final String root;
    private final String branch;
    private final String codeVersion;

    private Server(Builder builder) {
        this.host = builder.host;
        this.root = builder.root;
        this.branch = builder.branch;
        this.codeVersion = builder.codeVersion;
    }

    public String getHost() {
        return this.host;
    }

    public String getRoot() {
        return this.root;
    }

    public String getBranch() {
        return this.branch;
    }

    public String getCodeVersion() {
        return this.codeVersion;
    }

    @Override
    public Map<String, Object> asJson() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (this.host != null) {
            values.put("host", this.host);
        }
        if (this.root != null) {
            values.put("root", this.root);
        }
        if (this.branch != null) {
            values.put("branch", this.branch);
        }
        if (this.codeVersion != null) {
            values.put("code_version", this.codeVersion);
        }
        return values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server server = (Server)o;
        if (this.host != null ? !this.host.equals(server.host) : server.host != null) {
            return false;
        }
        if (this.root != null ? !this.root.equals(server.root) : server.root != null) {
            return false;
        }
        if (this.branch != null ? !this.branch.equals(server.branch) : server.branch != null) {
            return false;
        }
        return this.codeVersion != null ? this.codeVersion.equals(server.codeVersion) : server.codeVersion == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.root != null ? this.root.hashCode() : 0);
        result = 31 * result + (this.branch != null ? this.branch.hashCode() : 0);
        result = 31 * result + (this.codeVersion != null ? this.codeVersion.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "Server{host='" + this.host + '\'' + ", root='" + this.root + '\'' + ", branch='" + this.branch + '\'' + ", codeVersion='" + this.codeVersion + '\'' + '}';
    }

    public static final class Builder {
        private String host;
        private String root;
        private String branch;
        private String codeVersion;

        public Builder() {
        }

        public Builder(Server server) {
            this.host = server.host;
            this.root = server.root;
            this.branch = server.branch;
            this.codeVersion = server.codeVersion;
        }

        public Builder host(String host) {
            this.host = host;
            return this;
        }

        public Builder root(String root) {
            this.root = root;
            return this;
        }

        public Builder branch(String branch) {
            this.branch = branch;
            return this;
        }

        public Builder codeVersion(String codeVersion) {
            this.codeVersion = codeVersion;
            return this;
        }

        public Server build() {
            return new Server(this);
        }
    }
}

