/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.api.payload.data.body;

import com.rollbar.api.json.JsonSerializable;
import com.rollbar.api.payload.data.body.BodyContent;
import java.util.HashMap;
import java.util.Objects;

public class Message
implements BodyContent,
JsonSerializable {
    private final String body;

    private Message(Builder builder) {
        this.body = builder.body;
    }

    public String getBody() {
        return this.body;
    }

    @Override
    public String getKeyName() {
        return "message";
    }

    @Override
    public Object asJson() {
        HashMap<String, String> message = new HashMap<String, String>();
        message.put("body", this.body);
        return message;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Message message = (Message)o;
        return Objects.equals(this.body, message.body);
    }

    public int hashCode() {
        return Objects.hash(this.body);
    }

    public String toString() {
        return "Message{body='" + this.body + '\'' + '}';
    }

    public static final class Builder {
        private String body;

        public Builder() {
        }

        public Builder(Message message) {
            this.body = message.body;
        }

        public Builder body(String body) {
            this.body = body;
            return this;
        }

        public Message build() {
            return new Message(this);
        }
    }
}

