/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.exception.ApiException;
import com.rollbar.notifier.sender.exception.SenderException;
import com.rollbar.notifier.sender.listener.SenderListener;
import com.rollbar.notifier.sender.result.Response;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSender
implements Sender {
    private Logger LOGGER = LogManager.getLogger(this.getClass());
    private final List<SenderListener> listeners = new ArrayList<SenderListener>();

    protected abstract Response doSend(Payload var1) throws Exception;

    @Override
    public final void send(Payload payload) {
        try {
            Response response = this.doSend(payload);
            if (response.getResult().isError()) {
                this.notifyError(payload, new SenderException(new ApiException(response)));
            } else {
                this.notifyResult(payload, response);
            }
        }
        catch (Exception e) {
            this.notifyError(payload, new SenderException(e));
        }
    }

    @Override
    public final void addListener(SenderListener listener) {
        this.listeners.add(listener);
    }

    @Override
    public final List<SenderListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    @Override
    public void close() throws Exception {
    }

    private void notifyResult(Payload payload, Response response) {
        this.LOGGER.debug("Payload sent uuid: {}", (Object)response.getResult().getContent());
        for (SenderListener listener : this.listeners) {
            listener.onResponse(payload, response);
        }
    }

    private void notifyError(Payload payload, Exception error) {
        this.LOGGER.error("Error sending the payload.", (Throwable)error);
        for (SenderListener listener : this.listeners) {
            listener.onError(payload, error);
        }
    }
}

