/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender;

import com.rollbar.api.payload.Payload;
import com.rollbar.notifier.sender.Sender;
import com.rollbar.notifier.sender.SyncSender;
import com.rollbar.notifier.sender.exception.SenderException;
import com.rollbar.notifier.sender.listener.SenderListener;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class BufferedSender
implements Sender {
    private static final int DEFAULT_BATCH_SIZE = Integer.MAX_VALUE;
    private static final long DEFAULT_FLUSH_FREQ;
    private static final long DEFAULT_INITIAL_FLUSH_DELAY;
    private final int batchSize;
    private Sender sender;
    private Queue<Payload> queue;
    private ScheduledExecutorService executorService;

    BufferedSender(Builder builder) {
        this(builder, Executors.newSingleThreadScheduledExecutor(new SenderThreadFactory()));
    }

    BufferedSender(Builder builder, ScheduledExecutorService executorService) {
        Objects.requireNonNull(builder.sender, "The sender can not be null");
        Objects.requireNonNull(builder.queue, "The queue can not be null");
        this.batchSize = builder.batchSize;
        this.sender = builder.sender;
        this.queue = builder.queue;
        this.executorService = executorService;
        this.executorService.scheduleWithFixedDelay(new SendTask(this.batchSize, this.queue, this.sender), builder.initialFlushDelay, builder.flushFreq, TimeUnit.MILLISECONDS);
    }

    @Override
    public void send(Payload payload) {
        try {
            this.queue.add(payload);
        }
        catch (Exception e) {
            this.notifyError(payload, new SenderException(e));
        }
    }

    @Override
    public void addListener(SenderListener listener) {
        this.sender.addListener(listener);
    }

    @Override
    public List<SenderListener> getListeners() {
        return this.sender.getListeners();
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdown();
        this.sender.close();
    }

    private void notifyError(Payload payload, Exception e) {
        for (SenderListener listener : this.sender.getListeners()) {
            listener.onError(payload, e);
        }
    }

    static /* synthetic */ long access$500() {
        return DEFAULT_INITIAL_FLUSH_DELAY;
    }

    static /* synthetic */ long access$600() {
        return DEFAULT_FLUSH_FREQ;
    }

    static {
        DEFAULT_INITIAL_FLUSH_DELAY = DEFAULT_FLUSH_FREQ = TimeUnit.SECONDS.toMillis(5L);
    }

    static final class SenderThreadFactory
    implements ThreadFactory {
        SenderThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("rollbar-buffered_sender");
            thread.setDaemon(true);
            return thread;
        }
    }

    static final class SendTask
    implements Runnable {
        private final int batchSize;
        private final Queue<Payload> queue;
        private final Sender sender;

        public SendTask(int batchSize, Queue<Payload> queue, Sender sender) {
            this.batchSize = batchSize;
            this.queue = queue;
            this.sender = sender;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Payload payload = null;
            int numberOfSent = 0;
            try {
                while (numberOfSent < this.batchSize && (payload = this.queue.poll()) != null) {
                    try {
                        this.sender.send(payload);
                    }
                    catch (Exception exception) {}
                    continue;
                    finally {
                        ++numberOfSent;
                    }
                }
            }
            catch (Exception e) {
                for (SenderListener senderListener : this.sender.getListeners()) {
                    senderListener.onError(payload, new SenderException(e));
                }
            }
        }
    }

    public static final class Builder {
        private int batchSize = Integer.MAX_VALUE;
        private long initialFlushDelay = BufferedSender.access$500();
        private long flushFreq = BufferedSender.access$600();
        private Queue<Payload> queue;
        private Sender sender = null;

        public Builder batchSize(int batchSize) {
            this.batchSize = batchSize;
            return this;
        }

        public Builder initialFlushDelay(long initialFlushDelay) {
            this.initialFlushDelay = initialFlushDelay;
            return this;
        }

        public Builder flushFreq(long flushFreq) {
            this.flushFreq = flushFreq;
            return this;
        }

        public Builder queue(Queue<Payload> queue) {
            this.queue = queue;
            return this;
        }

        public Builder sender(Sender sender) {
            this.sender = sender;
            return this;
        }

        public BufferedSender build() {
            if (this.queue == null) {
                this.queue = new ConcurrentLinkedQueue<Payload>();
            }
            if (this.sender == null) {
                this.sender = new SyncSender.Builder().build();
            }
            return new BufferedSender(this);
        }
    }
}

