/*
 * Decompiled with CFR 0.152.
 */
package com.rollbar.notifier.sender.result;

import java.util.Objects;

public class Result {
    private static final int ERROR_CODE = 1;
    private final int err;
    private final String content;

    private Result(Builder builder) {
        this.err = builder.err;
        this.content = builder.content;
    }

    public int getErr() {
        return this.err;
    }

    public String getContent() {
        return this.content;
    }

    public boolean isError() {
        return this.err == 1;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Result result = (Result)o;
        return this.err == result.err && Objects.equals(this.content, result.content);
    }

    public int hashCode() {
        return Objects.hash(this.err, this.content);
    }

    public String toString() {
        return "Result{err=" + this.err + ", content='" + this.content + '\'' + '}';
    }

    public static final class Builder {
        private int err;
        private String content;

        public Builder code(int code) {
            this.err = code;
            return this;
        }

        public Builder body(String content) {
            this.content = content;
            return this;
        }

        public Result build() {
            return new Result(this);
        }
    }
}

