/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.energy;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagLong;
import net.minecraftforge.common.util.INBTSerializable;
import szewek.fl.energy.IEnergy;

public class Battery
implements IEnergy,
INBTSerializable<NBTBase> {
    protected long energy = 0L;
    protected final long maxEnergy;

    public Battery() {
        this(50000L);
    }

    public Battery(long max) {
        this.maxEnergy = max;
    }

    @Override
    public boolean canInputEnergy() {
        return true;
    }

    @Override
    public boolean canOutputEnergy() {
        return true;
    }

    @Override
    public long inputEnergy(long amount, boolean sim) {
        if (amount == 0L) {
            return 0L;
        }
        long r = this.maxEnergy - this.energy;
        if (amount > r) {
            amount = r;
        }
        if (!sim) {
            this.energy += amount;
        }
        return amount;
    }

    @Override
    public long outputEnergy(long amount, boolean sim) {
        if (amount == 0L) {
            return 0L;
        }
        if (amount > this.energy) {
            amount = this.energy;
        }
        if (!sim) {
            this.energy -= amount;
        }
        return amount;
    }

    @Override
    public long getEnergy() {
        return this.energy;
    }

    @Override
    public long getEnergyCapacity() {
        return this.maxEnergy;
    }

    @Override
    public void setEnergy(long amount) {
        this.energy = amount > this.maxEnergy ? this.maxEnergy : amount;
    }

    @Override
    public boolean hasNoEnergy() {
        return this.energy == 0L;
    }

    @Override
    public boolean hasFullEnergy() {
        return this.energy == this.maxEnergy;
    }

    @Override
    public long to(IEnergy ie, long amount) {
        if (amount > 0L && ie != null && ie.canInputEnergy()) {
            long r;
            if (amount > this.energy) {
                amount = this.energy;
            }
            if ((r = ie.inputEnergy(amount, true)) > 0L) {
                this.energy -= r;
                return ie.inputEnergy(r, false);
            }
        }
        return 0L;
    }

    public NBTBase serializeNBT() {
        return new NBTTagLong(this.energy);
    }

    public void deserializeNBT(NBTBase nbt) {
        if (!(nbt instanceof NBTTagLong)) {
            return;
        }
        this.energy = ((NBTTagLong)nbt).func_150291_c();
    }
}

