/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.energy;

import net.minecraftforge.energy.IEnergyStorage;
import szewek.fl.energy.IEnergy;

public final class ForgeEnergyWrapper
implements IEnergy {
    private final IEnergyStorage ies;

    public ForgeEnergyWrapper(IEnergyStorage ies) {
        this.ies = ies;
    }

    @Override
    public boolean canInputEnergy() {
        return this.ies.canReceive();
    }

    @Override
    public boolean canOutputEnergy() {
        return this.ies.canExtract();
    }

    @Override
    public long inputEnergy(long amount, boolean sim) {
        return this.ies.receiveEnergy(amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount, sim);
    }

    @Override
    public long outputEnergy(long amount, boolean sim) {
        return this.ies.extractEnergy(amount > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount, sim);
    }

    @Override
    public long getEnergy() {
        return this.ies.getEnergyStored();
    }

    @Override
    public long getEnergyCapacity() {
        return this.ies.getMaxEnergyStored();
    }

    @Override
    public boolean hasNoEnergy() {
        return this.ies.getEnergyStored() == 0;
    }

    @Override
    public boolean hasFullEnergy() {
        return this.ies.getEnergyStored() == this.ies.getMaxEnergyStored();
    }
}

