/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.fluxwork;

import javax.annotation.Nonnull;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import szewek.fl.FL;
import szewek.fl.energy.IEnergy;
import szewek.fl.fluxwork.WorkState;

public abstract class TileEntityFluxWork
extends TileEntity
implements ITickable,
IEnergy {
    protected WorkState workState = WorkState.LAZY;
    protected long energy;
    protected long maxEnergy;
    protected int workNeeded;
    protected int workDone;

    protected abstract boolean canWork();

    protected abstract boolean hasWork();

    protected abstract int beginWork();

    protected abstract void work();

    protected abstract boolean workEnding();

    protected abstract void finishWork();

    protected abstract void tick();

    protected abstract void tickClient();

    protected abstract boolean canChangeEnergy();

    public final void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            this.tickClient();
            return;
        }
        if (!this.canWork()) {
            this.workState = WorkState.LAZY;
        } else if (!this.hasWork()) {
            this.workDone = 0;
            this.workNeeded = this.beginWork();
            this.workState = WorkState.WORKING;
        } else if (this.canChangeEnergy()) {
            this.work();
            ++this.workDone;
            if (this.workNeeded <= this.workDone) {
                this.finishWork();
                this.workState = WorkState.FINISHED;
            }
        }
    }

    @Override
    public long getEnergy() {
        return this.energy;
    }

    @Override
    public long getEnergyCapacity() {
        return this.maxEnergy;
    }

    public boolean hasCapability(@Nonnull Capability<?> cap, EnumFacing f) {
        return cap == FL.ENERGY_CAP || super.hasCapability(cap, f);
    }

    public <T> T getCapability(@Nonnull Capability<T> cap, EnumFacing f) {
        return (T)(cap == FL.ENERGY_CAP ? this : super.getCapability(cap, f));
    }
}

