/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.INetHandler;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IThreadListener;
import net.minecraft.util.Tuple;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import szewek.fl.FL;
import szewek.fl.FLX;
import szewek.fl.network.FLNetMsg;
import szewek.fl.network.FLNetUtil;
import szewek.fl.proxy.FLProxy;

@ChannelHandler.Sharable
@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0003\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B#\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0014\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006\u00a2\u0006\u0002\u0010\tJ\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0002H\u0014J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J*\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u001aH\u0002J\u0016\u0010\u001b\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001e\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bJ\u0016\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010 \u001a\u00020!J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\bJ\u0018\u0010&\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010'\u001a\u00020\u001aH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lszewek/fl/network/FLNetChannel;", "Lio/netty/channel/SimpleChannelInboundHandler;", "Lnet/minecraftforge/fml/common/network/internal/FMLProxyPacket;", "chname", "", "ids", "", "Ljava/lang/Class;", "Lszewek/fl/network/FLNetMsg;", "(Ljava/lang/String;Ljava/util/List;)V", "cliChan", "Lnet/minecraftforge/fml/common/network/FMLEmbeddedChannel;", "srvChan", "channelRead0", "", "ctx", "Lio/netty/channel/ChannelHandlerContext;", "msg", "exceptionCaught", "cause", "", "send", "ch", "ot", "Lnet/minecraftforge/fml/common/network/FMLOutboundHandler$OutboundTarget;", "arg", "", "to", "mp", "Lnet/minecraft/entity/player/EntityPlayerMP;", "toAll", "toAllAround", "tp", "Lnet/minecraftforge/fml/common/network/NetworkRegistry$TargetPoint;", "toDimension", "dimId", "", "toServer", "userEventTriggered", "evt", "fl"})
public final class FLNetChannel
extends SimpleChannelInboundHandler<FMLProxyPacket> {
    private final FMLEmbeddedChannel srvChan;
    private final FMLEmbeddedChannel cliChan;
    private final String chname;
    private final List<Class<? extends FLNetMsg>> ids;

    protected void channelRead0(@NotNull ChannelHandlerContext ctx, @NotNull FMLProxyPacket msg) throws Exception {
        block12: {
            Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
            Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
            try {
                Tuple<IThreadListener, EntityPlayer> tup;
                FLProxy fLProxy = FLX.PROXY;
                if (fLProxy == null) {
                    Intrinsics.throwNpe();
                }
                FLNetUtil fLNetUtil = fLProxy.getNetUtil();
                INetHandler iNetHandler = msg.handler();
                Intrinsics.checkExpressionValueIsNotNull((Object)iNetHandler, (String)"msg.handler()");
                Side s = fLNetUtil.check(iNetHandler);
                FLProxy fLProxy2 = FLX.PROXY;
                if (fLProxy2 == null) {
                    Intrinsics.throwNpe();
                }
                FLNetUtil fLNetUtil2 = fLProxy2.getNetUtil();
                Side side = s;
                if (side == null) {
                    Intrinsics.throwNpe();
                }
                if ((tup = fLNetUtil2.preprocess(msg, side)) == null) {
                    Logger logger = FL.Companion.getL();
                    if (logger == null) {
                        Intrinsics.throwNpe();
                    }
                    logger.warn("No Tuple");
                    return;
                }
                IThreadListener itl = (IThreadListener)tup.func_76341_a();
                EntityPlayer ep = (EntityPlayer)tup.func_76340_b();
                ByteBuf byteBuf = msg.payload();
                if (byteBuf == null) {
                    throw new TypeCastException("null cannot be cast to non-null type net.minecraft.network.PacketBuffer");
                }
                PacketBuffer pb = (PacketBuffer)byteBuf;
                if (pb == null) {
                    pb = new PacketBuffer(msg.payload());
                }
                byte id = pb.readByte();
                FLNetMsg fm = this.ids.get(id).newInstance();
                IThreadListener iThreadListener = itl;
                Intrinsics.checkExpressionValueIsNotNull((Object)iThreadListener, (String)"itl");
                if (iThreadListener.func_152345_ab()) break block12;
                try {
                    fm.decode(pb);
                }
                catch (Exception fx) {
                    fm.exception(fx);
                }
                itl.func_152344_a((Runnable)new FLNetMsg.Decode(fm, ep, s));
            }
            catch (Exception x) {
                Logger logger = FL.Companion.getL();
                if (logger == null) {
                    Intrinsics.throwNpe();
                }
                logger.error("[FLNetChannel] Exception thrown while decoding!", (Throwable)x);
            }
        }
    }

    public void userEventTriggered(@NotNull ChannelHandlerContext ctx, @NotNull Object evt) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)evt, (String)"evt");
    }

    public void exceptionCaught(@NotNull ChannelHandlerContext ctx, @NotNull Throwable cause) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)ctx, (String)"ctx");
        Intrinsics.checkParameterIsNotNull((Object)cause, (String)"cause");
        Logger logger = FL.Companion.getL();
        if (logger == null) {
            Intrinsics.throwNpe();
        }
        logger.error("FLNetChannel exception", cause);
        super.exceptionCaught(ctx, cause);
    }

    private final void send(FMLEmbeddedChannel ch, FLNetMsg msg, FMLOutboundHandler.OutboundTarget ot, Object arg) {
        PacketBuffer pb = new PacketBuffer(Unpooled.buffer());
        byte id = (byte)this.ids.indexOf(msg.getClass());
        pb.writeByte((int)id);
        try {
            msg.encode(pb);
        }
        catch (Exception x) {
            msg.exception(x);
            return;
        }
        ch.attr(FMLOutboundHandler.FML_MESSAGETARGET).set((Object)ot);
        if (arg != null) {
            ch.attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).set(arg);
        }
        ch.writeAndFlush((Object)new FMLProxyPacket(pb, this.chname)).addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public final void to(@NotNull FLNetMsg msg, @NotNull EntityPlayerMP mp) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)mp, (String)"mp");
        this.send(this.srvChan, msg, FMLOutboundHandler.OutboundTarget.PLAYER, mp);
    }

    public final void toAll(@NotNull FLNetMsg msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        this.send(this.srvChan, msg, FMLOutboundHandler.OutboundTarget.ALL, null);
    }

    public final void toAllAround(@NotNull FLNetMsg msg, @NotNull NetworkRegistry.TargetPoint tp) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        Intrinsics.checkParameterIsNotNull((Object)tp, (String)"tp");
        this.send(this.srvChan, msg, FMLOutboundHandler.OutboundTarget.ALLAROUNDPOINT, tp);
    }

    public final void toDimension(@NotNull FLNetMsg msg, int dimId) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        this.send(this.srvChan, msg, FMLOutboundHandler.OutboundTarget.DIMENSION, dimId);
    }

    public final void toServer(@NotNull FLNetMsg msg) {
        Intrinsics.checkParameterIsNotNull((Object)msg, (String)"msg");
        this.send(this.cliChan, msg, FMLOutboundHandler.OutboundTarget.TOSERVER, null);
    }

    public FLNetChannel(@NotNull String chname, @NotNull List<? extends Class<? extends FLNetMsg>> ids) {
        Intrinsics.checkParameterIsNotNull((Object)chname, (String)"chname");
        Intrinsics.checkParameterIsNotNull(ids, (String)"ids");
        this.chname = chname;
        this.ids = ids;
        EnumMap channels = NetworkRegistry.INSTANCE.newChannel(this.chname, new ChannelHandler[]{(ChannelHandler)this});
        Object v = channels.get(Side.SERVER);
        if (v == null) {
            Intrinsics.throwNpe();
        }
        this.srvChan = (FMLEmbeddedChannel)v;
        Object v2 = channels.get(Side.CLIENT);
        if (v2 == null) {
            Intrinsics.throwNpe();
        }
        this.cliChan = (FMLEmbeddedChannel)v2;
    }
}

