/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.taste;

import javax.annotation.Nonnull;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import szewek.fl.taste.ILikesTaste;

public abstract class Taste {
    public final String name;
    public final NBTTagCompound data;

    public Taste(String name, NBTTagCompound data) {
        this.name = name;
        this.data = data;
    }

    public abstract long getAmount();

    public boolean areSameTaste(Taste t) {
        return this.name != null && t.name != null && this.name.equals(t.name) && (this.data == null && t.data == null || this.data != null && this.data.equals((Object)t.data));
    }

    public Immutable makeImmutable(long amount) {
        return new Immutable(this.name, this.data, amount);
    }

    public Mutable makeMutable(long amount) {
        return new Mutable(this.name, this.data, amount);
    }

    public NBTTagCompound toNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74778_a("name", this.name);
        nbt.func_74772_a("amount", this.getAmount());
        if (this.data != null) {
            nbt.func_74782_a("data", (NBTBase)this.data);
        }
        return nbt;
    }

    public static <T extends Taste> T fromNBT(@Nonnull NBTTagCompound nbt, @Nonnull Factory<T> factory) {
        String name = nbt.func_74779_i("name");
        long amount = nbt.func_74763_f("amount");
        NBTTagCompound data = null;
        if (nbt.func_150297_b("data", 10)) {
            data = nbt.func_74775_l("data");
        }
        return factory.create(name, data, amount);
    }

    @FunctionalInterface
    public static interface Factory<T extends Taste> {
        public T create(String var1, NBTTagCompound var2, long var3);
    }

    public static class Storage
    extends Mutable
    implements ILikesTaste {
        private final long capacity;
        private final Taste accepted;

        public Storage() {
            this("", null, 50000L);
        }

        public Storage(String name, NBTTagCompound data, long cap) {
            super(name, data, 0L);
            this.capacity = cap;
            this.accepted = this.makeImmutable(0L);
        }

        @Override
        public boolean canInputTaste(Taste t) {
            return this.areSameTaste(t);
        }

        @Override
        public boolean canOutputTaste(Taste t) {
            return this.areSameTaste(t);
        }

        @Override
        public long inputTaste(Taste t, boolean sim) {
            long r;
            if (!this.areSameTaste(t)) {
                return 0L;
            }
            long a = t.getAmount();
            if (a < (r = this.capacity - this.amount)) {
                r = a;
            }
            if (!sim) {
                this.amount += r;
            }
            return r;
        }

        @Override
        public long outputTaste(Taste t, boolean sim) {
            long r;
            if (!this.areSameTaste(t)) {
                return 0L;
            }
            long a = t.getAmount();
            if (a < (r = this.amount)) {
                r = a;
            }
            if (!sim) {
                this.amount -= r;
            }
            return r;
        }

        @Override
        public Taste outputAnyTaste(long amount, boolean sim) {
            if (this.amount > 0L) {
                long r;
                long l = r = amount < this.amount ? amount : this.amount;
                if (!sim) {
                    this.amount -= r;
                }
                return new Immutable(this.name, this.data.func_74737_b(), r);
            }
            return null;
        }

        @Override
        public long getTasteAmount(Taste t) {
            return this.areSameTaste(t) ? this.amount : 0L;
        }

        @Override
        public long getTasteCapacity(Taste t) {
            return this.areSameTaste(t) ? this.capacity : 0L;
        }

        @Override
        public Taste[] allTastesContained() {
            return new Taste[]{this.accepted};
        }

        @Override
        public Taste[] allTastesAcceptable() {
            return new Taste[]{this.accepted};
        }
    }

    public static class Mutable
    extends Taste {
        protected long amount;

        public Mutable(String name, NBTTagCompound data, long amount) {
            super(name, data);
            this.amount = amount;
        }

        @Override
        public long getAmount() {
            return this.amount;
        }

        public void setAmount(long amount) {
            this.amount = amount;
        }
    }

    public static final class Immutable
    extends Taste {
        private final long amount;

        public Immutable(String name, NBTTagCompound data, long amount) {
            super(name, data);
            this.amount = amount;
        }

        @Override
        public long getAmount() {
            return this.amount;
        }
    }
}

