/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;

@OnlyIn(value=Dist.CLIENT)
public final class DrawUtils {
    private DrawUtils() {
    }

    public static void drawRectBatchOnly(double left, double top, double right, double bottom, int c, double z) {
        double p;
        if (left < right) {
            p = left;
            left = right;
            right = p;
        }
        if (top < bottom) {
            p = top;
            top = bottom;
            bottom = p;
        }
        int ya = c >> 24 & 0xFF;
        int yr = c >> 16 & 0xFF;
        int yg = c >> 8 & 0xFF;
        int yb = c & 0xFF;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vb.func_225582_a_(left, bottom, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_225582_a_(right, bottom, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_225582_a_(right, top, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_225582_a_(left, top, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        tes.func_78381_a();
    }

    public static void drawGradientRectBatchOnly(double left, double top, double right, double bottom, int color1, int color2, double z) {
        int ya = color1 >> 24 & 0xFF;
        int yr = color1 >> 16 & 0xFF;
        int yg = color1 >> 8 & 0xFF;
        int yb = color1 & 0xFF;
        int za = color2 >> 24 & 0xFF;
        int zr = color2 >> 16 & 0xFF;
        int zg = color2 >> 8 & 0xFF;
        int zb = color2 & 0xFF;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (right - left > bottom - top) {
            vb.func_225582_a_(right, top, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_225582_a_(left, top, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_225582_a_(left, bottom, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_225582_a_(right, bottom, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        } else {
            vb.func_225582_a_(right, top, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_225582_a_(left, top, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_225582_a_(left, bottom, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_225582_a_(right, bottom, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
        }
        tes.func_78381_a();
    }

    public static void drawFluidStack(int x, int y, int w, int h, FluidStack fs, int cap, float z) {
        if (fs.isEmpty()) {
            return;
        }
        Fluid fl = fs.getFluid();
        if (fl == Fluids.field_204541_a) {
            return;
        }
        ResourceLocation still = fl.getAttributes().getStillTexture();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureAtlasSprite tas = (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
        minecraft.field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        DrawUtils.glColorInt(fl.getAttributes().getColor(fs));
        int ny = y + h;
        int nh = Math.min(h * fs.getAmount() / cap, h);
        int xTiles = w >> 4;
        int xRemainder = w & 0xF;
        int yTiles = nh >> 4;
        int yRemainder = nh & 0xF;
        float uMin = tas.func_94209_e();
        float uMax = tas.func_94212_f();
        float vMin = tas.func_94206_g();
        float vMax = tas.func_94210_h();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        for (int xt = 0; xt <= xTiles; ++xt) {
            int width = xt == xTiles ? xRemainder : 16;
            int tx = x + xt * 16;
            for (int yt = 0; yt <= yTiles; ++yt) {
                int height = yt == yTiles ? yRemainder : 16;
                int ty = ny - (yt + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                uMax -= (float)maskRight / 16.0f * (uMax - uMin);
                vMax -= (float)maskTop / 16.0f * (vMax - vMin);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_225582_a_((double)tx, (double)(ty + 16), (double)z).func_225583_a_(uMin, vMax).func_181675_d();
                buf.func_225582_a_((double)(tx + 16 - maskRight), (double)(ty + 16), (double)z).func_225583_a_(uMax, vMax).func_181675_d();
                buf.func_225582_a_((double)(tx + 16 - maskRight), (double)(ty + maskTop), (double)z).func_225583_a_(uMax, vMin).func_181675_d();
                buf.func_225582_a_((double)tx, (double)(ty + maskTop), (double)z).func_225583_a_(uMin, vMin).func_181675_d();
                tes.func_78381_a();
            }
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    public static void glColorInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }
}

