/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import szewek.fl.gui.DrawUtils;
import szewek.fl.gui.GuiRect;

@OnlyIn(value=Dist.CLIENT)
public class GuiBar
extends GuiRect {
    private final int c1;
    private final int c2;
    private final boolean reverse;

    public GuiBar(int x1, int y1, int x2, int y2, int c1, int c2, boolean reverse) {
        super(x1, y1, x2, y2);
        this.c1 = c1;
        this.c2 = c2;
        this.reverse = reverse;
    }

    public void draw(float fill, double z) {
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        DrawUtils.drawRectBatchOnly(this.x1, this.y1, this.x2, this.y2, -13487566, z);
        int x1 = this.x1 + 1;
        int y1 = this.y1 + 1;
        int x2 = this.x2 - 1;
        int y2 = this.y2 - 1;
        if (fill > 0.0f) {
            DrawUtils.drawGradientRectBatchOnly(x1, y1, x2, y2, this.c1, this.c2, z);
            if (x2 - x1 > y2 - y1) {
                int f = MathHelper.func_76123_f((float)((float)(x2 - x1) * fill));
                if (this.reverse) {
                    x1 += f;
                } else {
                    x2 -= f;
                }
            } else {
                int f = MathHelper.func_76123_f((float)((float)(y2 - y1) * fill));
                if (this.reverse) {
                    y1 += f;
                } else {
                    y2 -= f;
                }
            }
        }
        DrawUtils.drawRectBatchOnly(x1, y1, x2, y2, -15395563, z);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

