/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import szewek.fl.gui.GuiRect;

public class HoverSet {
    private final Set<GuiRect> rects = new HashSet<GuiRect>();
    private HoverListener hoverListener;

    public HoverSet(HoverListener onHover) {
        this.hoverListener = onHover;
    }

    public void addAll(GuiRect ... rect) {
        Collections.addAll(this.rects, rect);
    }

    public void checkCoords(int x, int y) {
        if (this.hoverListener != null) {
            for (GuiRect r : this.rects) {
                if (x < r.x1 || x >= r.x2 || y < r.y1 || y >= r.y2) continue;
                this.hoverListener.onHover(r, x, y);
            }
        }
    }

    public static interface HoverListener {
        public void onHover(GuiRect var1, int var2, int var3);
    }
}

