/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.network;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.nio.charset.StandardCharsets;
import szewek.fl.network.FluxPlus;

public class APICall {
    private final HttpURLConnection conn;

    APICall(HttpURLConnection conn) {
        this.conn = conn;
    }

    private void checkStatus() throws IOException {
        int status = this.conn.getResponseCode();
        if (status / 100 != 2) {
            InputStream err = this.conn.getErrorStream();
            ByteArrayOutputStream bs = new ByteArrayOutputStream(Math.max(32, err.available()));
            ByteStreams.copy((InputStream)err, (OutputStream)bs);
            err.close();
            throw new IOException("HTTP " + status + ": " + bs.toString("UTF-8"));
        }
    }

    public APICall post(Object obj) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("Content-Type", "application/json;charset=utf-8");
        this.conn.setDoOutput(true);
        OutputStream out = this.conn.getOutputStream();
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8);
        FluxPlus.GSON.toJson(obj, (Appendable)writer);
        writer.close();
        return this;
    }

    public <T> T response(Class<T> type) throws IOException {
        this.checkStatus();
        InputStream in = this.conn.getInputStream();
        InputStreamReader reader = new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8);
        Object t = FluxPlus.GSON.fromJson((Reader)reader, type);
        reader.close();
        return (T)t;
    }
}

