/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.network;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import szewek.fl.network.APICall;

public final class FluxPlus {
    private static final String HOST = "https://fluxplus.herokuapp.com/api";
    private static final Logger LOGGER = LogManager.getLogger((String)"Flux+");
    static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final ExecutorService EXEC = new ThreadPoolExecutor(0, 2, 30L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());

    private FluxPlus() {
    }

    private static APICall connect(String path) throws IOException {
        HttpURLConnection huc = (HttpURLConnection)new URL(HOST + path).openConnection();
        return new APICall(huc);
    }

    public static void putAction(String type) {
        EXEC.execute(() -> {
            try {
                boolean b = FluxPlus.connect("/collect/action?type=" + type).response(Boolean.TYPE);
                if (!b) {
                    LOGGER.warn("Action type {} is not acceptable", (Object)type);
                }
            }
            catch (Exception e) {
                LOGGER.error("Exception while registering an action", (Throwable)e);
            }
        });
    }

    public static void reportRecipeCompatError(String recipeType, String className, String msg) {
        EXEC.execute(() -> {
            try {
                ImmutableMap m = ImmutableMap.of((Object)"recipeType", (Object)recipeType, (Object)"class", (Object)className, (Object)"msg", (Object)msg);
                FluxPlus.connect("/report/recipeCompat").post(m).response(Boolean.TYPE);
            }
            catch (Exception e) {
                LOGGER.error("Exception while sending recipe compat error", (Throwable)e);
            }
        });
    }
}

