/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.recipe;

import com.google.gson.JsonObject;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraftforge.common.crafting.IIngredientSerializer;

@MethodsReturnNonnullByDefault
public class CountedIngredient
extends Ingredient {
    private final int count;
    private boolean counted;

    CountedIngredient(Stream<? extends Ingredient.IItemList> stream, int count) {
        super(stream);
        this.count = count;
    }

    public int getCount() {
        return this.count;
    }

    public ItemStack[] func_193365_a() {
        ItemStack[] stacks = super.func_193365_a();
        if (!this.counted) {
            for (ItemStack stack : stacks) {
                stack.func_190920_e(this.count);
            }
            this.counted = true;
        }
        return stacks;
    }

    public boolean test(@Nullable ItemStack stack) {
        return super.test(stack) && stack.func_190916_E() >= this.count;
    }

    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static class Serializer
    implements IIngredientSerializer<CountedIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        public CountedIngredient parse(PacketBuffer buffer) {
            int count = buffer.func_150792_a();
            return new CountedIngredient(Stream.generate(() -> new Ingredient.SingleItemList(buffer.func_150791_c())).limit(buffer.func_150792_a()), count);
        }

        public CountedIngredient parse(JsonObject json) {
            int count = JSONUtils.func_151208_a((JsonObject)json, (String)"count", (int)1);
            return new CountedIngredient(Stream.of(Ingredient.func_199803_a((JsonObject)json)), count);
        }

        public void write(PacketBuffer buffer, CountedIngredient ingredient) {
            buffer.func_150787_b(ingredient.count);
            ItemStack[] items = ingredient.func_193365_a();
            buffer.func_150787_b(items.length);
            for (ItemStack stack : items) {
                buffer.func_150788_a(stack);
            }
        }
    }
}

