/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class LogTimer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final String name;
    private int count;
    private long sum;

    public LogTimer(String name) {
        this.name = name;
    }

    public long start() {
        return System.nanoTime();
    }

    public void stop(long t) {
        this.sum += System.nanoTime() - t;
        ++this.count;
        if (this.count == 5) {
            LOGGER.debug("Timer [{}] mean: {} ns", (Object)this.name, (Object)Float.valueOf((float)this.sum / 5.0f));
            this.count = 0;
            this.sum = 0;
        }
    }
}

