/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import szewek.fl.util.GeoFunction;

public abstract class SpatialWalker {
    private int x;
    private int y;
    private int z;
    protected final int minX;
    protected final int minY;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY;
    protected final int maxZ;
    private Action[] actions;

    public SpatialWalker(int ax, int ay, int az, int zx, int zy, int zz) {
        this.minX = ax;
        this.minY = ay;
        this.minZ = az;
        this.maxX = zx;
        this.maxY = zy;
        this.maxZ = zz;
    }

    public abstract boolean canWalk();

    public void startFrom(boolean sx, boolean sy, boolean sz) {
        this.x = sx ? this.minX : this.maxX;
        this.y = sy ? this.minY : this.maxY;
        this.z = sz ? this.minZ : this.maxZ;
    }

    public void putActions(Action ... actions) {
        this.actions = (Action[])actions.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean walk() {
        if (this.canWalk()) {
            block9: for (int i = 0; i < this.actions.length; ++i) {
                Action a = this.actions[i];
                switch (a) {
                    case X_POS: {
                        if (++this.x <= this.maxX) break;
                        this.x = this.minX;
                        continue block9;
                    }
                    case X_NEG: {
                        if (--this.x >= this.minX) break;
                        this.x = this.maxX;
                        continue block9;
                    }
                    case Y_POS: {
                        if (++this.y <= this.maxY) break;
                        this.y = this.minY;
                        continue block9;
                    }
                    case Y_NEG: {
                        if (--this.y >= this.minY) break;
                        this.y = this.maxY;
                        continue block9;
                    }
                    case Z_POS: {
                        if (++this.z <= this.maxZ) break;
                        this.z = this.minZ;
                        continue block9;
                    }
                    case Z_NEG: {
                        if (--this.z >= this.minZ) break;
                        this.z = this.maxZ;
                        continue block9;
                    }
                    case LOOP: {
                        i = -1;
                        continue block9;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void read(CompoundNBT compound) {
        this.x = compound.func_74762_e("OffX");
        this.y = compound.func_74762_e("OffY");
        this.z = compound.func_74762_e("OffZ");
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("OffX", this.x);
        compound.func_74768_a("OffY", this.y);
        compound.func_74768_a("OffZ", this.z);
        return compound;
    }

    public BlockPos getPosOffset(BlockPos pos) {
        return pos.func_177982_a(this.x, this.y, this.z);
    }

    public <T> Iterator<T> iterator(final GeoFunction<T> gf) {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                return SpatialWalker.this.walk();
            }

            @Override
            public T next() {
                return gf.apply(SpatialWalker.this.x, SpatialWalker.this.y, SpatialWalker.this.z);
            }
        };
    }

    public <T> Spliterator<T> spliterator(GeoFunction<T> gf) {
        long l = this.actions[this.actions.length - 1] == Action.LOOP ? Long.MAX_VALUE : (long)(this.maxX - this.minX + 1) * (long)(this.maxY - this.minY + 1) * (long)(this.maxZ - this.minZ + 1);
        return Spliterators.spliterator(this.iterator(gf), l, 0);
    }

    public <T> Stream<T> stream(GeoFunction<T> gf, boolean parallel) {
        return StreamSupport.stream(this.spliterator(gf), parallel);
    }

    public static enum Action {
        X_POS,
        X_NEG,
        Y_POS,
        Y_NEG,
        Z_POS,
        Z_NEG,
        LOOP;

    }

    public static class NonStop
    extends SpatialWalker {
        public NonStop(int x, int y, int z) {
            super(-x, -y, -z, x, y, z);
        }

        public NonStop(int ax, int ay, int az, int zx, int zy, int zz) {
            super(ax, ay, az, zx, zy, zz);
        }

        @Override
        public boolean canWalk() {
            return true;
        }
    }
}

