/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fluids.FluidStack;
import szewek.fl.gui.GuiRect;

@OnlyIn(value=Dist.CLIENT)
public final class DrawUtils {
    private DrawUtils() {
    }

    public static void drawRectBatchOnly(Matrix4f matrix, GuiRect rect, int c, float z) {
        int ya = c >> 24 & 0xFF;
        int yr = c >> 16 & 0xFF;
        int yg = c >> 8 & 0xFF;
        int yb = c & 0xFF;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y2, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y2, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y1, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y1, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        tes.func_78381_a();
    }

    public static void drawGradientRectBatchOnly(Matrix4f matrix, GuiRect rect, int color1, int color2, float z) {
        int ya = color1 >> 24 & 0xFF;
        int yr = color1 >> 16 & 0xFF;
        int yg = color1 >> 8 & 0xFF;
        int yb = color1 & 0xFF;
        int za = color2 >> 24 & 0xFF;
        int zr = color2 >> 16 & 0xFF;
        int zg = color2 >> 8 & 0xFF;
        int zb = color2 & 0xFF;
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder vb = tes.func_178180_c();
        vb.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        if (rect.x2 - rect.x1 > rect.y2 - rect.y1) {
            vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y1, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y1, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y2, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y2, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
        } else {
            vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y1, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y1, z).func_225586_a_(yr, yg, yb, ya).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x1, (float)rect.y2, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
            vb.func_227888_a_(matrix, (float)rect.x2, (float)rect.y2, z).func_225586_a_(zr, zg, zb, za).func_181675_d();
        }
        tes.func_78381_a();
    }

    public static void drawFluidStack(Matrix4f matrix, GuiRect rect, FluidStack fs, int cap, float z) {
        TextureAtlasSprite tas = DrawUtils.applyFluidTexture(fs);
        if (tas == null) {
            return;
        }
        int w = rect.x2 - rect.x1;
        int nh = (rect.y2 - rect.y1) * Math.min(fs.getAmount() / cap, 1);
        int xTiles = w >> 4;
        int xRemainder = w & 0xF;
        int yTiles = nh >> 4;
        int yRemainder = nh & 0xF;
        float uMin = tas.func_94209_e();
        float uMax = tas.func_94212_f();
        float vMin = tas.func_94206_g();
        float vMax = tas.func_94210_h();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buf = tes.func_178180_c();
        RenderSystem.enableBlend();
        RenderSystem.enableAlphaTest();
        for (int xt = 0; xt <= xTiles; ++xt) {
            int width = xt == xTiles ? xRemainder : 16;
            int tx = xt * 16 + rect.x1;
            for (int yt = 0; yt <= yTiles; ++yt) {
                int height = yt == yTiles ? yRemainder : 16;
                int ty = rect.y2 - (yt + 1) * 16;
                if (width <= 0 || height <= 0) continue;
                int maskTop = 16 - height;
                int maskRight = 16 - width;
                uMax -= (float)maskRight / 16.0f * (uMax - uMin);
                vMax -= (float)maskTop / 16.0f * (vMax - vMin);
                buf.func_181668_a(7, DefaultVertexFormats.field_181707_g);
                buf.func_227888_a_(matrix, (float)tx, (float)(ty + 16), z).func_225583_a_(uMin, vMax).func_181675_d();
                buf.func_227888_a_(matrix, (float)(tx + 16 - maskRight), (float)(ty + 16), z).func_225583_a_(uMax, vMax).func_181675_d();
                buf.func_227888_a_(matrix, (float)(tx + 16 - maskRight), (float)(ty + maskTop), z).func_225583_a_(uMax, vMin).func_181675_d();
                buf.func_227888_a_(matrix, (float)tx, (float)(ty + maskTop), z).func_225583_a_(uMin, vMin).func_181675_d();
                tes.func_78381_a();
            }
        }
        RenderSystem.disableAlphaTest();
        RenderSystem.disableBlend();
    }

    private static TextureAtlasSprite applyFluidTexture(FluidStack fs) {
        if (fs.isEmpty()) {
            return null;
        }
        Fluid fl = fs.getFluid();
        if (fl == Fluids.field_204541_a) {
            return null;
        }
        ResourceLocation still = fl.getAttributes().getStillTexture();
        Minecraft minecraft = Minecraft.func_71410_x();
        TextureAtlasSprite tas = (TextureAtlasSprite)minecraft.func_228015_a_(PlayerContainer.field_226615_c_).apply(still);
        minecraft.field_71446_o.func_110577_a(PlayerContainer.field_226615_c_);
        DrawUtils.glColorInt(fl.getAttributes().getColor(fs));
        return tas;
    }

    public static void glColorInt(int color) {
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = (float)(color >> 24 & 0xFF) / 255.0f;
        RenderSystem.color4f((float)red, (float)green, (float)blue, (float)alpha);
    }
}

