/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import szewek.fl.gui.DrawUtils;
import szewek.fl.gui.GuiRect;

@OnlyIn(value=Dist.CLIENT)
public class GuiBar {
    public final GuiRect rect;
    private final GuiRect rectShrink;
    private final int c1;
    private final int c2;
    private final boolean reverse;

    public GuiBar(GuiRect rect, int c1, int c2, boolean reverse) {
        this.rect = rect;
        this.rectShrink = rect.grow(-1);
        this.c1 = c1;
        this.c2 = c2;
        this.reverse = reverse;
    }

    public void draw(MatrixStack matrixStack, float fill, float z) {
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.disableAlphaTest();
        RenderSystem.defaultBlendFunc();
        RenderSystem.shadeModel((int)7425);
        DrawUtils.drawRectBatchOnly(matrix, this.rect, -13487566, z);
        int x1 = this.rectShrink.x1;
        int y1 = this.rectShrink.y1;
        int x2 = this.rectShrink.x2;
        int y2 = this.rectShrink.y2;
        if (fill > 0.0f) {
            DrawUtils.drawGradientRectBatchOnly(matrix, this.rectShrink, this.c1, this.c2, z);
            if (this.rect.x2 - this.rect.x1 > this.rect.y2 - this.rect.y1) {
                int f = MathHelper.func_76123_f((float)((float)(x2 - x1) * fill));
                if (this.reverse) {
                    x1 += f;
                } else {
                    x2 -= f;
                }
            } else {
                int f = MathHelper.func_76123_f((float)((float)(y2 - y1) * fill));
                if (this.reverse) {
                    y1 += f;
                } else {
                    y2 -= f;
                }
            }
        }
        DrawUtils.drawRectBatchOnly(matrix, new GuiRect(x1, y1, x2, y2), -15395563, z);
        RenderSystem.shadeModel((int)7424);
        RenderSystem.disableBlend();
        RenderSystem.enableAlphaTest();
        RenderSystem.enableTexture();
    }
}

