/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.gui;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import szewek.fl.gui.GuiRect;

public class HoverSet {
    private final Set<GuiRect> rects = new HashSet<GuiRect>();
    private final HoverListener hoverListener;

    public HoverSet(HoverListener onHover) {
        this.hoverListener = onHover;
    }

    public void addAll(GuiRect ... rect) {
        Collections.addAll(this.rects, rect);
    }

    public void checkCoords(MatrixStack matrixStack, int x, int y) {
        if (this.hoverListener != null) {
            for (GuiRect r : this.rects) {
                if (x < r.x1 || x >= r.x2 || y < r.y1 || y >= r.y2) continue;
                this.hoverListener.onHover(r, matrixStack, x, y);
            }
        }
    }

    public static interface HoverListener {
        public void onHover(GuiRect var1, MatrixStack var2, int var3, int var4);
    }
}

