/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.network;

import com.google.common.io.ByteStreams;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import szewek.fl.network.FluxAnalytics;

public class APICall {
    private final HttpURLConnection conn;

    APICall(HttpURLConnection conn) {
        this.conn = conn;
    }

    public static APICall to(String url) throws IOException {
        HttpURLConnection huc = (HttpURLConnection)new URL(url).openConnection();
        return new APICall(huc);
    }

    public void checkStatus() throws IOException {
        int status = this.conn.getResponseCode();
        if (status / 100 != 2) {
            InputStream err = this.conn.getErrorStream();
            ByteArrayOutputStream bs = new ByteArrayOutputStream(Math.max(32, err.available()));
            ByteStreams.copy((InputStream)err, (OutputStream)bs);
            err.close();
            throw new IOException("HTTP " + status + ": " + bs.toString("UTF-8"));
        }
    }

    private Writer preparePost(String type) throws IOException {
        this.conn.setRequestMethod("POST");
        this.conn.setRequestProperty("User-Agent", "FL-Client/1.0");
        this.conn.setRequestProperty("Content-Type", type);
        this.conn.setDoOutput(true);
        OutputStream out = this.conn.getOutputStream();
        return new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), StandardCharsets.UTF_8);
    }

    public APICall post(Object obj) throws IOException {
        Writer w = this.preparePost("application/json;charset=utf-8");
        FluxAnalytics.GSON.toJson(obj, (Appendable)w);
        w.close();
        return this;
    }

    public APICall postString(String s, String type) throws IOException {
        Writer w = this.preparePost(type);
        w.write(s);
        w.close();
        return this;
    }

    public Reader prepareResponse() throws IOException {
        this.checkStatus();
        InputStream in = this.conn.getInputStream();
        return new InputStreamReader((InputStream)new BufferedInputStream(in), StandardCharsets.UTF_8);
    }

    public <T> T response(Class<T> type) throws IOException {
        Reader r = this.prepareResponse();
        Object t = FluxAnalytics.GSON.fromJson(r, type);
        r.close();
        return (T)t;
    }
}

