/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.recipe;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraftforge.common.util.RecipeMatcher;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class RecipeCompat {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Map<IRecipeType<?>, Set<IRecipeType<?>>> compatMap = new ConcurrentHashMap();

    public static <C extends IInventory, T extends IRecipe<C>> Optional<IRecipe<C>> getCompatRecipe(IRecipeType<?> rtype, World w, IInventory inv) {
        RecipeManager rm = w.func_199532_z();
        Iterator<IRecipeType<?>> iterator = compatMap.getOrDefault(rtype, Collections.singleton(rtype)).iterator();
        while (iterator.hasNext()) {
            IRecipeType<?> rt;
            IRecipeType<?> recipeType = rt = iterator.next();
            for (IRecipe r : rm.func_215366_a(recipeType).values()) {
                try {
                    if (!r.func_77569_a(inv, w)) continue;
                    return Optional.of(r);
                }
                catch (RuntimeException e) {
                    LOGGER.warn("An exception occurred while checking recipe ({}) [type {}]", (Object)r.func_199560_c(), (Object)recipeType.toString());
                }
            }
        }
        return Optional.empty();
    }

    public static void registerCompatRecipeTypes(IRecipeType<?> rtype, Iterable<String> compats) {
        ResourceLocation loc = Registry.field_218367_H.func_177774_c(rtype);
        if (loc == null || !"flux".equals(loc.func_110624_b())) {
            return;
        }
        LinkedHashSet result = new LinkedHashSet();
        result.add(rtype);
        for (String compat : compats) {
            Optional value = Registry.field_218367_H.func_241873_b(new ResourceLocation(compat));
            value.ifPresent(result::add);
        }
        compatMap.put(rtype, result);
    }

    public static ItemStack getCompatOutput(IRecipe<?> recipe, IInventory inv) {
        ItemStack stack = recipe.func_77571_b();
        if (stack.func_190926_b()) {
            LOGGER.warn("Returned ItemStack from [{}] is EMPTY", (Object)recipe.func_222127_g().toString());
        }
        return stack;
    }

    public static Consumer<Iterable<ItemStack>> getRecipeItemsConsumer(IRecipe<?> recipe) {
        NonNullList ingredients;
        Consumer<Iterable> consumer = recipe instanceof Consumer ? (Consumer<Iterable>)recipe : ((ingredients = recipe.func_192400_c()).isEmpty() ? stacks -> {
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b()) continue;
                stack.func_190917_f(-1);
            }
        } : stacks -> {
            ArrayList<ItemStack> filledInputs = new ArrayList<ItemStack>();
            for (ItemStack stack : stacks) {
                if (stack.func_190926_b()) continue;
                filledInputs.add(stack);
            }
            int[] match = RecipeMatcher.findMatches(filledInputs, (List)ingredients);
            if (match != null) {
                for (int i = 0; i < match.length; ++i) {
                    ((ItemStack)filledInputs.get(i)).func_190917_f(-1);
                }
            }
        });
        return consumer;
    }

    private RecipeCompat() {
    }
}

