/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util;

import java.util.List;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraftforge.fluids.FluidStack;

public final class FluidsUtil {
    private FluidsUtil() {
    }

    public static void saveAllFluids(CompoundNBT tag, List<FluidStack> fluids, boolean saveEmpty) {
        ListNBT fluidNBT = new ListNBT();
        for (int i = 0; i < fluids.size(); ++i) {
            FluidStack fs = fluids.get(i);
            if (fs == null || fs.isEmpty()) continue;
            CompoundNBT nbt = new CompoundNBT();
            nbt.func_74774_a("Slot", (byte)i);
            fs.writeToNBT(nbt);
            fluidNBT.add((Object)nbt);
        }
        if (!fluidNBT.isEmpty() || saveEmpty) {
            tag.func_218657_a("Fluids", (INBT)fluidNBT);
        }
    }

    public static void loadAllFluids(CompoundNBT tag, List<FluidStack> fluids) {
        ListNBT fluidNBT = tag.func_150295_c("Fluids", 10);
        for (int i = 0; i < fluidNBT.size(); ++i) {
            CompoundNBT nbt = fluidNBT.func_150305_b(i);
            int j = nbt.func_74771_c("Slot") & 0xFF;
            if (j >= fluids.size()) continue;
            fluids.set(j, FluidStack.loadFluidStackFromNBT((CompoundNBT)nbt));
        }
    }
}

