/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util;

import java.util.Iterator;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;

public final class ItemsUtil {
    private static final Direction[] DIRS = Direction.values();

    public static void trySendingItems(Iterable<ItemStack> items, World world, BlockPos pos) {
        IItemHandler[] inv = new IItemHandler[6];
        int size = 0;
        for (Direction dir : DIRS) {
            IItemHandler iih;
            TileEntity te = world.func_175625_s(pos.func_177972_a(dir));
            if (te == null || (iih = ItemsUtil.getItemHandlerCompat(te, dir.func_176734_d())) == null) continue;
            inv[size++] = iih;
        }
        Iterator<ItemStack> iterator = items.iterator();
        block1: while (iterator.hasNext()) {
            ItemStack stack;
            ItemStack tempStack = stack = (ItemStack)iterator.next();
            for (int z = 0; z < size; ++z) {
                IItemHandler iih = inv[z];
                int l = iih.getSlots();
                for (int i = 0; i < l; ++i) {
                    if (iih.isItemValid(i, tempStack) && (tempStack = iih.insertItem(i, tempStack, false)).func_190926_b()) continue block1;
                }
            }
            InventoryHelper.func_180173_a((World)world, (double)pos.func_177958_n(), (double)(pos.func_177956_o() + 1), (double)pos.func_177952_p(), (ItemStack)tempStack);
        }
    }

    public static IItemHandler getItemHandlerCompat(TileEntity tile, Direction dir) {
        LazyOptional il = tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, dir.func_176734_d());
        IItemHandler iih = null;
        if (il.isPresent()) {
            iih = (IItemHandler)il.orElse(null);
        } else if (tile instanceof IInventory) {
            iih = new InvWrapper((IInventory)tile);
        }
        return iih;
    }

    private ItemsUtil() {
    }
}

