/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.Direction;
import net.minecraftforge.common.util.LazyOptional;

public class SideCached<T> {
    private final LazyOptional<T>[] cacheArray = new LazyOptional[6];
    private final Function<Direction, LazyOptional<T>> getFromDir;

    public SideCached(Function<Direction, LazyOptional<T>> dirFn) {
        this.getFromDir = dirFn;
    }

    @Nullable
    public T getCached(Direction dir) {
        int d = dir.ordinal();
        LazyOptional<T> lazy = this.cacheArray[d];
        if (lazy == null && (lazy = this.getFromDir.apply(dir)).isPresent()) {
            lazy.addListener(l -> {
                this.cacheArray[d] = null;
            });
            this.cacheArray[d] = lazy;
        }
        return (T)lazy.orElse(null);
    }

    public void clear() {
        for (int i = 0; i < 6; ++i) {
            this.cacheArray[i] = null;
        }
    }
}

