/*
 * Decompiled with CFR 0.152.
 */
package szewek.fl.util.spatial;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import szewek.fl.util.spatial.WalkAction;

public abstract class SpatialWalker {
    private int x;
    private int y;
    private int z;
    protected final int minX;
    protected final int minY;
    protected final int minZ;
    protected final int maxX;
    protected final int maxY;
    protected final int maxZ;
    private WalkAction[] actions;

    public SpatialWalker(int ax, int ay, int az, int zx, int zy, int zz) {
        this.minX = ax;
        this.minY = ay;
        this.minZ = az;
        this.maxX = zx;
        this.maxY = zy;
        this.maxZ = zz;
    }

    public abstract boolean canWalk();

    public void startFrom(boolean sx, boolean sy, boolean sz) {
        this.x = sx ? this.minX : this.maxX;
        this.y = sy ? this.minY : this.maxY;
        this.z = sz ? this.minZ : this.maxZ;
    }

    public void putActions(WalkAction ... actions) {
        this.actions = (WalkAction[])actions.clone();
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean walk() {
        if (this.canWalk()) {
            block9: for (int i = 0; i < this.actions.length; ++i) {
                WalkAction a = this.actions[i];
                switch (a) {
                    case X_POS: {
                        if (++this.x <= this.maxX) break;
                        this.x = this.minX;
                        continue block9;
                    }
                    case X_NEG: {
                        if (--this.x >= this.minX) break;
                        this.x = this.maxX;
                        continue block9;
                    }
                    case Y_POS: {
                        if (++this.y <= this.maxY) break;
                        this.y = this.minY;
                        continue block9;
                    }
                    case Y_NEG: {
                        if (--this.y >= this.minY) break;
                        this.y = this.maxY;
                        continue block9;
                    }
                    case Z_POS: {
                        if (++this.z <= this.maxZ) break;
                        this.z = this.minZ;
                        continue block9;
                    }
                    case Z_NEG: {
                        if (--this.z >= this.minZ) break;
                        this.z = this.maxZ;
                        continue block9;
                    }
                    case LOOP: {
                        i = -1;
                        continue block9;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public void read(CompoundNBT compound) {
        this.x = compound.func_74762_e("OffX");
        this.y = compound.func_74762_e("OffY");
        this.z = compound.func_74762_e("OffZ");
    }

    public CompoundNBT write(CompoundNBT compound) {
        compound.func_74768_a("OffX", this.x);
        compound.func_74768_a("OffY", this.y);
        compound.func_74768_a("OffZ", this.z);
        return compound;
    }

    public BlockPos getPosOffset(BlockPos pos) {
        return pos.func_177982_a(this.x, this.y, this.z);
    }
}

