/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.api.ArmorRemoveHandler;
import com.kwpugh.gobber2.api.ArmorTickable;
import com.kwpugh.gobber2.util.PlayerEquipUtil;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1304;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2588;

public class DragonArmor
extends class_1738
implements ArmorRemoveHandler,
ArmorTickable {
    static boolean enableHealing = Gobber2.CONFIG.GENERAL.enableHealingPerks;
    static boolean enableProtection = Gobber2.CONFIG.GENERAL.enableProtectiveEffects;
    static boolean enableNoFall = Gobber2.CONFIG.GENERAL.enableNoFallDamage;
    static boolean unbreakable = Gobber2.CONFIG.GENERAL.unbreakableDragonArmor;
    static int healing = Gobber2.CONFIG.GENERAL.gobberDragonArmorHealingPoints;
    static boolean enableFlight = Gobber2.CONFIG.GENERAL.enableFlight;

    public DragonArmor(class_1741 material, class_1304 slot, class_1792.class_1793 settings) {
        super(material, slot, settings);
    }

    @Override
    public void tickArmor(class_1799 stack, class_1657 player) {
        class_1937 world = player.field_6002;
        if (PlayerEquipUtil.isPlayerWearingDragonArmor(player)) {
            if (enableHealing && player.field_6012 % 180 == 0) {
                PlayerSpecialAbilities.giveGreaterAbsorption(world, player, stack);
                PlayerSpecialAbilities.giveSaturationEffect(world, player, stack);
                PlayerSpecialAbilities.giveHealing(world, player, stack, healing);
            }
            if (enableProtection) {
                PlayerSpecialAbilities.giveWaterBreathing(world, player);
                PlayerSpecialAbilities.givePhoenixEffect(world, player);
                PlayerSpecialAbilities.giveCuringEffect(world, player);
            }
            if (enableNoFall) {
                player.field_6017 = 0.0f;
            }
        }
        if (PlayerEquipUtil.isPlayerWearingDragonArmor(player) && enableFlight) {
            player.method_31549().field_7478 = true;
        }
    }

    @Override
    public void onRemoved(class_1657 player) {
        if (!(this.field_7880 != class_1304.field_6169 && this.field_7880 != class_1304.field_6174 && this.field_7880 != class_1304.field_6172 && this.field_7880 != class_1304.field_6166 || player.method_7337() || player.method_7325())) {
            player.method_31549().field_7478 = false;
            player.method_31549().field_7479 = false;
        }
    }

    public void method_7843(class_1799 stack, class_1937 world, class_1657 player) {
        if (unbreakable) {
            stack.method_7948().method_10556("Unbreakable", true);
        }
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip1").method_27692(class_124.field_1060));
        if (enableFlight) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_armor_dragon.tip2").method_27692(class_124.field_1060));
        }
    }
}

