/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.init;

import com.google.common.collect.Lists;
import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.init.ItemInit;
import java.util.List;
import net.fabricmc.fabric.api.loot.v1.FabricLootPoolBuilder;
import net.fabricmc.fabric.api.loot.v1.FabricLootSupplierBuilder;
import net.fabricmc.fabric.api.loot.v1.event.LootTableLoadingCallback;
import net.minecraft.class_1935;
import net.minecraft.class_219;
import net.minecraft.class_2960;
import net.minecraft.class_44;
import net.minecraft.class_55;
import net.minecraft.class_59;
import net.minecraft.class_77;
import net.minecraft.class_79;
import org.apache.commons.lang3.ArrayUtils;

public class LootTableInit {
    static boolean enable = Gobber2.CONFIG.GENERAL.lootEnable;
    static float lootChance = Gobber2.CONFIG.GENERAL.lootChance;
    private static final List<LootTableInsert> INSERTS = Lists.newArrayList();

    public static void registerLoot() {
        if (enable) {
            FabricLootPoolBuilder GOBBER_RING_RETURN = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)ItemInit.GOBBER2_RING_RETURN)).withCondition(class_219.method_932((float)lootChance).build());
            LootTableInit.insert(new LootTableInsert(GOBBER_RING_RETURN, new class_2960("minecraft", "chests/desert_pyramid"), new class_2960("minecraft", "chests/jungle_temple"), new class_2960("minecraft", "chests/igloo_chest"), new class_2960("minecraft", "chests/pillager_outpost")));
            FabricLootPoolBuilder GOBBER_RING_TELEPORT = FabricLootPoolBuilder.builder().rolls((class_59)class_44.method_289((int)1)).with((class_79.class_80)class_77.method_411((class_1935)ItemInit.GOBBER2_RING_TELEPORT)).withCondition(class_219.method_932((float)lootChance).build());
            LootTableInit.insert(new LootTableInsert(GOBBER_RING_TELEPORT, new class_2960("minecraft", "chests/stronghold_library"), new class_2960("minecraft", "chests/pillager_outpost"), new class_2960("minecraft", "chests/nether_bridge"), new class_2960("minecraft", "chests/shipwreck_treasure")));
            LootTableLoadingCallback.EVENT.register((resourceManager, lootManager, identifier, supplier, lootTableSetter) -> INSERTS.forEach(i -> {
                if (ArrayUtils.contains((Object[])i.tables, (Object)identifier)) {
                    i.insert(supplier);
                }
            }));
        }
    }

    public static void insert(LootTableInsert insert) {
        INSERTS.add(insert);
    }

    public static class LootTableInsert {
        public final class_2960[] tables;
        public final FabricLootPoolBuilder lootPool;

        public LootTableInsert(FabricLootPoolBuilder lootPool, class_2960 ... tables) {
            this.tables = tables;
            this.lootPool = lootPool;
        }

        public void insert(FabricLootSupplierBuilder supplier) {
            supplier.pool((class_55.class_56)this.lootPool);
        }
    }
}

