/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.world.Gobber2Dimension;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5321;

public class RingTeleport
extends class_1792 {
    public RingTeleport(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (RingTeleport.getPosition(stack) != null && !player.method_5715()) {
            this.teleport(player, world, stack);
        }
        if (RingTeleport.getPosition(stack) != null && player.method_5715()) {
            RingTeleport.setPosition(stack, world, null, player);
            player.method_7353((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip8"), true);
        }
        return new class_1271(class_1269.field_5812, (Object)stack);
    }

    public class_1269 method_7884(class_1838 context) {
        class_1937 world = context.method_8045();
        class_2338 pos = context.method_8037();
        class_1657 player = context.method_8036();
        class_2350 direction = context.method_8038();
        class_1799 stack = context.method_8036().method_6047();
        if (RingTeleport.getPosition(stack) == null && !player.method_5715()) {
            player.method_7353((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip2"), true);
        }
        if (RingTeleport.getPosition(stack) == null && player.method_5715()) {
            RingTeleport.setPosition(stack, world, pos.method_10093(direction), player);
            player.method_7353((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip6", new Object[]{this.getLocationString(stack)}).method_27692(class_124.field_1060), true);
            return class_1269.field_5812;
        }
        if (RingTeleport.getPosition(stack) != null) {
            player.method_7353((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip7", new Object[]{this.getLocationString(stack)}).method_27692(class_124.field_1054), true);
            return class_1269.field_5812;
        }
        return class_1269.field_5812;
    }

    public static class_2338 getPosition(class_1799 stack) {
        class_2487 tags = stack.method_7969();
        if (stack.method_7985() && tags.method_10545("pos")) {
            class_2487 subTags = stack.method_7911("pos");
            return class_2512.method_10691((class_2487)subTags);
        }
        return null;
    }

    public static String getDimension(class_1799 stack) {
        class_2487 tags = stack.method_7969();
        if (stack.method_7985() && tags.method_10545("dim")) {
            return stack.method_7969().method_10558("dim");
        }
        return null;
    }

    public static void setPosition(class_1799 stack, class_1937 world, class_2338 pos, class_1657 player) {
        if (world.field_9236) {
            return;
        }
        class_2487 tags = !stack.method_7985() ? new class_2487() : stack.method_7969();
        if (pos == null) {
            tags.method_10551("pos");
            tags.method_10551("dim");
        } else {
            class_5321 registryKey = world.method_27983();
            tags.method_10566("pos", (class_2520)class_2512.method_10692((class_2338)pos));
            if (registryKey == class_1937.field_25179) {
                tags.method_10582("dim", "Overworld");
            }
            if (registryKey == class_1937.field_25180) {
                tags.method_10582("dim", "The Nether");
            }
            if (registryKey == class_1937.field_25181) {
                tags.method_10582("dim", "The End");
            }
            if (registryKey == Gobber2Dimension.GOBBER_WORLD_KEY) {
                tags.method_10582("dim", "Mining World");
            }
            if (registryKey == Gobber2Dimension.GOBBER_WORLD_KEY2) {
                tags.method_10582("dim", "Hunting World");
            }
            if (registryKey == Gobber2Dimension.GOBBER_WORLD_KEY3) {
                tags.method_10582("dim", "Caving World");
            }
            if (registryKey == Gobber2Dimension.GOBBER_WORLD_KEY4) {
                tags.method_10582("dim", "Nethering World");
            }
        }
        stack.method_7980(tags);
    }

    public void teleport(class_1657 player, class_1937 world, class_1799 stack) {
        if (world.field_9236) {
            return;
        }
        class_2338 pos = RingTeleport.getPosition(stack);
        String dim = RingTeleport.getDimension(stack);
        class_5321 registryKey = world.method_27983();
        class_3218 serverWorld = ((class_3218)world).method_8503().method_3847(registryKey);
        class_3218 overWorld = ((class_3218)world).method_8503().method_3847(class_1937.field_25179);
        class_3218 netherWorld = ((class_3218)world).method_8503().method_3847(class_1937.field_25180);
        class_3218 endWorld = ((class_3218)world).method_8503().method_3847(class_1937.field_25181);
        class_3218 miningWorld = ((class_3218)world).method_8503().method_3847(Gobber2Dimension.GOBBER_WORLD_KEY);
        class_3218 huntingWorld = ((class_3218)world).method_8503().method_3847(Gobber2Dimension.GOBBER_WORLD_KEY2);
        class_3218 cavingWorld = ((class_3218)world).method_8503().method_3847(Gobber2Dimension.GOBBER_WORLD_KEY3);
        class_3218 netheringWorld = ((class_3218)world).method_8503().method_3847(Gobber2Dimension.GOBBER_WORLD_KEY4);
        class_3222 serverPlayer = (class_3222)player;
        class_3218 destWorld = null;
        boolean unknownWorld = false;
        if (stack.method_7969().method_10558("dim").contains("Overworld")) {
            destWorld = overWorld;
        } else if (stack.method_7969().method_10558("dim").contains("The Nether")) {
            destWorld = netherWorld;
        } else if (stack.method_7969().method_10558("dim").contains("The End")) {
            destWorld = endWorld;
        } else if (stack.method_7969().method_10558("dim").contains("Mining World")) {
            destWorld = miningWorld;
        } else if (stack.method_7969().method_10558("dim").contains("Hunting World")) {
            destWorld = huntingWorld;
        } else if (stack.method_7969().method_10558("dim").contains("Caving World")) {
            destWorld = cavingWorld;
        } else if (stack.method_7969().method_10558("dim").contains("Nethering World")) {
            destWorld = netheringWorld;
        } else {
            unknownWorld = true;
        }
        if (unknownWorld) {
            serverPlayer.method_7353((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip9"), true);
        } else if (serverWorld == destWorld) {
            serverPlayer.method_5859((double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f));
            world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
        } else if (serverWorld != destWorld) {
            serverPlayer.method_14251(destWorld, (double)((float)pos.method_10263() + 0.5f), (double)pos.method_10264(), (double)((float)pos.method_10260() + 0.5f), serverPlayer.field_6031, serverPlayer.field_5965);
            world.method_8465(null, player.method_23317(), player.method_23318(), player.method_23321(), class_3417.field_14890, class_3419.field_15248, 1.0f, 1.0f);
        }
    }

    public String getLocationString(class_1799 stack) {
        int storedX = stack.method_7911("pos").method_10550("X");
        int storedY = stack.method_7911("pos").method_10550("Y");
        int storedZ = stack.method_7911("pos").method_10550("Z");
        String storedWorld = stack.method_7969().method_10558("dim");
        String displayInfo = storedWorld + "  x: " + storedX + " y: " + storedY + " z: " + storedZ;
        return displayInfo;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip1").method_27692(class_124.field_1060));
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip2").method_27692(class_124.field_1054));
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip3").method_27692(class_124.field_1054));
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip4").method_27692(class_124.field_1054));
        if (RingTeleport.getPosition(stack) != null) {
            tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_ring_teleport.tip5", new Object[]{this.getLocationString(stack)}).method_27692(class_124.field_1061));
        }
    }
}

